package com.digiwin.mobile.mobileuibot.core.customtaskconfig;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：定制任务配置相关服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTaskConfigServiceImpl
 * @Author: Liux
 * @Date: 2022/04/13 17:00
 */
@Service("customTaskConfigService")
public class CustomTaskConfigServiceImpl implements CustomTaskConfigService{
    private static final Logger logger = LoggerFactory.getLogger(CustomTaskConfigServiceImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override public List<CustomTaskConfig> listCustomTaskConfig() {
        Query query = new Query();
        return this.mongoTemplate.find(query, CustomTaskConfig.class);
    }
}
