package com.digiwin.mobile.mobileuibot.core.customtaskconfig;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：定制任务URL配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTaskUrlConfig
 * @Author: Liux
 * @Date: 2022/04/14 10:26
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CustomTaskUrlConfig implements Serializable {
    private static final long serialVersionUID = -7984118157325999337L;

    /**
     * 任务栏跳转H5页面用到的字段
     */
    //协议名,http、或者https
    private String scheme;
    //host地址
    private String host;
    //port端口号,默认80。如果配置scheme=https，则默认为443
    private String port;
    //方法路径
    private String uri;

    public String getScheme() {
        if (null == scheme || scheme.trim().isEmpty()) {
            return "http";
        }
        return scheme;
    }

    public String getPort() {
        if ("http".equalsIgnoreCase(this.getScheme())) {
            if (null == port || port.trim().isEmpty()) {
                return "80";
            } else {
                return port;
            }
        } else if ("https".equalsIgnoreCase(this.getScheme())) {
            if (null == port || port.trim().isEmpty()) {
                return "443";
            } else {
                return port;
            }
        } else {
            return "80";
        }
    }

    public String getUri() {
        return uri;
    }
}
