package com.digiwin.mobile.mobileuibot.core.hooks;

import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileUiBotHooksServiceImpl
 * @Author: xujin
 * @Date: 2024/10/24 10:49
 */
@Service
public class MobileUiBotHooksServiceImpl implements MobileUiBotHooksService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<MobileUiBotHooks> findByPageId(String pageId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("pageId").is(pageId));
        return this.mongoTemplate.find(query, MobileUiBotHooks.class);
    }
}
