package com.digiwin.mobile.mobileuibot.core.layout;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：布局生成器所需的预处理数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutGeneratorPreprocessData
 * @Author: zaregoto
 * @Date: 2023/3/17 14:19
 */
@Slf4j
@Data
@Builder
@AllArgsConstructor
public class LayoutGeneratorPreprocessData implements Serializable {
    private static final long serialVersionUID = -1424391806254765919L;

    private ApiRequest apiRequest;

    /**
     * 待渲染版本。会影响最终生成的布局组件选择<br/>
     * 单层布局时，v1会生成CustomGroup，v2会生成SingleListContainer<br/>
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData
     * @since 2.5.1
     */
    private Integer renderVersion;

    /**
     * PC端UIBot的DSL
     */
    private UiBotModel pcUiBotModel;

    /**
     * 业务数据，可能会有多组
     * key-业务数据path，用于标识业务数据
     * value-业务数据本体
     */
    private Map<String, Object> bizDataMap;

    /**
     * 业务元数据，可能会有多组
     * key-元数据path，用于标识元数据
     * value-元数据本体
     */
    private Map<String, Object> bizMetadataMap;

    /**
     * 场景数据，可能会有多组
     * key-场景数据path，用于标识场景数据
     * value-场景数据本体
     */
    private Map<String, Object> scenerioDataMap;

    /**
     * 场景元数据，可能会有多组
     * key-场景元数据path，用于标识场景元数据
     * value-场景元数据本体
     */
    private Map<String, Object> scenerioMetadataMap;


    public LayoutGeneratorPreprocessData() {
        this.bizDataMap = new HashMap<>(1);
        this.bizMetadataMap = new HashMap<>(1);
        this.scenerioDataMap = new HashMap<>(1);
        this.scenerioMetadataMap = new HashMap<>(1);
    }

    /**
     * 添加一份预处理数据
     *
     * @param dataTypeEnum 预处理数据类型枚举
     * @param key          预处理数据在map中保存的key
     * @param data         预处理数据本体
     * @return 当前预处理数据对象
     */
    public LayoutGeneratorPreprocessData addData(LayoutGeneratorPreprocessDataTypeEnum dataTypeEnum, String key, Object data) {
        switch (dataTypeEnum) {
            case BIZ_DATA_TYPE:
                this.bizDataMap.put(key, data);
                break;
            case BIZ_METADATA_TYPE:
                this.bizMetadataMap.put(key, data);
                break;
            case SCENERIO_DATA_TYPE:
                this.scenerioDataMap.put(key, data);
                break;
            case SCENERIO_METADATA_TYPE:
                this.scenerioMetadataMap.put(key, data);
                break;
            default:
                log.debug("传入的LayoutGeneratorPreprocessDataTypeEnum不存在，不会保存任何数据……");
                break;
        }
        return this;
    }
}