package com.digiwin.mobile.mobileuibot.core.layout;

import java.util.Objects;

/**
 * <p>功能描述：布局生成器所需的预处理数据类型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutGeneratorPreprocessDataTypeEnum
 * @Author: zaregoto
 * @Date: 2023/3/17 14:33
 */
public enum LayoutGeneratorPreprocessDataTypeEnum {
    /**
     * 业务数据类型
     */
    BIZ_DATA_TYPE("BIZ_DATA_TYPE"),

    /**
     * 业务元数据类型
     */
    BIZ_METADATA_TYPE("BIZ_METADATA_TYPE"),

    /**
     * 场景数据类型
     */
    SCENERIO_DATA_TYPE("SCENERIO_DATA_TYPE"),

    /**
     * 场景元数据类型
     */
    SCENERIO_METADATA_TYPE("SCENERIO_METADATA_TYPE"),

    ;

    private final String value;

    LayoutGeneratorPreprocessDataTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static LayoutGeneratorPreprocessDataTypeEnum getEnumByValue(String value) {
        for (LayoutGeneratorPreprocessDataTypeEnum testedEnum : LayoutGeneratorPreprocessDataTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
