package com.digiwin.mobile.mobileuibot.core.layout;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeight;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeightReader;
import com.digiwin.mobile.mobileuibot.core.layout.generator.LayoutGenerator;
import com.digiwin.mobile.mobileuibot.core.layout.generator.LayoutGeneratorFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * <p>功能描述：布局生成器服务实现类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutGeneratorServiceImpl
 * @Author: zaregoto
 * @Date: 2023/3/17 15:48
 */
@Slf4j
@Component("layoutGeneratorServiceImpl")
public class LayoutGeneratorServiceImpl implements LayoutGeneratorService {

    private final LayoutAnalyzerFactory layoutAnalyzerFactory;

    private final LayoutAnalyzerWeightReader layoutAnalyzerWeightReader;

    private final LayoutGeneratorFactory layoutGeneratorFactory;

    public LayoutGeneratorServiceImpl(LayoutAnalyzerFactory layoutAnalyzerFactory,
                                      LayoutAnalyzerWeightReader layoutAnalyzerWeightReader,
                                      LayoutGeneratorFactory layoutGeneratorFactory) {
        this.layoutAnalyzerFactory = layoutAnalyzerFactory;
        this.layoutAnalyzerWeightReader = layoutAnalyzerWeightReader;
        this.layoutGeneratorFactory = layoutGeneratorFactory;
    }

    @Override
    public LayoutGeneratorServiceResult generate(LayoutGeneratorPreprocessData preprocessData) {
        // 通过业务数据判断布局类型
        MobileLayoutTypeEnum bizDataDrivenLayout =
                this.layoutAnalyzerFactory.get(LayoutAnalyzerTypeEnum.BIZ_DATA_TYPE.getValue())
                        .getLayoutType(preprocessData);
//        // TODO 通过场景数据判断布局类型
//        MobileLayoutTypeEnum scenerioDataDrivenLayout = null;

        // 读取布局分析器中权重最大的一个类型
        LayoutAnalyzerWeight maxLayoutAnalyzerWeight =
                this.layoutAnalyzerWeightReader.getMaxWeight();

        LayoutGenerator layoutGenerator = null;
        BaseLayoutMobileComponent resultLayoutComponent = null;
        switch (maxLayoutAnalyzerWeight.getLayoutAnalyzerTypeEnum()) {
            case BIZ_DATA_TYPE:
                // 使用bizDataDrivenLayout的值生成布局
                layoutGenerator = this.layoutGeneratorFactory.get(bizDataDrivenLayout.getValue());
                if (Objects.nonNull(layoutGenerator)) {
                    resultLayoutComponent = layoutGenerator.generate(preprocessData);
                }
                break;
//            case SCENERIO_DATA_TYPE:
//                // TODO 通过场景数据判断布局类型
//                // 使用scenerioDataDrivenLayout的值生成布局
//                layoutGenerator = this.layoutGeneratorFactory.get(scenerioDataDrivenLayout.getValue());
//                if (Objects.nonNull(layoutGenerator)) {
//                    resultLayoutComponent = layoutGenerator.generate(preprocessData);
//                }
//                break;
            default:
                resultLayoutComponent = null;
                break;
        }
        MobileLayoutTypeEnum mobileLayoutTypeEnum;
        if (Objects.isNull(layoutGenerator)) {
            mobileLayoutTypeEnum = MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT;
        } else {
            mobileLayoutTypeEnum = MobileLayoutTypeEnum.getEnumByValue(layoutGenerator.getType());
        }

        return LayoutGeneratorServiceResult.builder()
                .maxLayoutAnalyzerWeight(maxLayoutAnalyzerWeight)
                .layoutTypeEnum(mobileLayoutTypeEnum)
                .layoutMobileComponent(resultLayoutComponent)
                .build();
    }
}
