package com.digiwin.mobile.mobileuibot.core.layout;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.layout.analyzer.LayoutAnalyzerWeight;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <p>功能描述：布局生成服务的生成结果</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutGeneratorServiceResult
 * @Author: zaregoto
 * @Date: 2023/3/23 18:14
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LayoutGeneratorServiceResult {
    /**
     * 最大权重的布局分析器对象
     */
    private LayoutAnalyzerWeight maxLayoutAnalyzerWeight;

    /**
     * 生成的布局类型
     */
    private MobileLayoutTypeEnum layoutTypeEnum;

    /**
     * 生成的布局组件
     */
    private BaseLayoutMobileComponent layoutMobileComponent;

}
