package com.digiwin.mobile.mobileuibot.core.layout.analyzer;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：布局分析器工厂</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutAnalyzerFactory
 * @Author: zaregoto
 * @Date: 2023/3/17 14:59
 */
@Slf4j
@Component
public class LayoutAnalyzerFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, LayoutAnalyzer> MAP = new HashMap<>();

    private ApplicationContext appContext;

    public LayoutAnalyzer get(String key) {
        return MAP.get(key);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 YourStrategyInterface 注册到 MAP
        this.appContext.getBeansOfType(LayoutAnalyzer.class).values().forEach(
                strategy -> MAP.put(strategy.getType(), strategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        this.appContext = applicationContext;
    }
}