package com.digiwin.mobile.mobileuibot.core.layout.analyzer;

import java.util.Objects;

/**
 * <p>功能描述：不同布局分析器类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutAnalyzerTypeEnum
 * @Author: zaregoto
 * @Date: 2023/3/15 15:25
 */
public enum LayoutAnalyzerTypeEnum {
    /**
     * 基于业务数据的布局分析器
     */
    BIZ_DATA_TYPE("BIZ_DATA_TYPE"),

    /**
     * 基于场景数据的布局分析器
     */
    SCENERIO_DATA_TYPE("SCENERIO_DATA_TYPE"),

    ;

    private final String value;

    LayoutAnalyzerTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static LayoutAnalyzerTypeEnum getEnumByValue(String value) {
        for (LayoutAnalyzerTypeEnum testedEnum : LayoutAnalyzerTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
