package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean;

/**
 * PC端UiBot使用的布局枚举
 *
 * @author wuyang
 */
public enum PcLayoutEnum {

    /**
     * 表单列表布局
     */
    FORM_LIST("FORM_LIST"),

    /**
     * 表格布局
     */
    ATHENA_TABLE("ATHENA_TABLE"),
    /**
     * 图布局
     */
    ECHARTS("ECHARTS"),
    /**
     * 旧表格布局
     */
    TABLE("TABLE"),

    /**
     * 分栏布局
     */
    SPLIT_LAYOUT("SPLIT_LAYOUT"),

    APPROVAL_DESCRIPTION("uiBot__APPROVAL_DESCRIPTION"),

    ;

    private String value;

    PcLayoutEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static PcLayoutEnum getEnumByName(String name) {
        String tester = name;
        for (PcLayoutEnum pcModuleEnum :
                PcLayoutEnum.values()) {
            if (pcModuleEnum.name().equalsIgnoreCase(tester)) {
                return pcModuleEnum;
            }
        }
        return null;
    }
}
