package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean;

/**
 * @author wuyang
 */
public enum PcModuleEnum {

    /**
     * 对应标题组件
     */
    ACTIVITY_TITLE("ACTIVITY_TITLE"),
    DELIVERY_REPLY_TITLE("DELIVERY_REPLY_TITLE"),

    //描述组件
    DELIVERY_REPLY_DESCRIPTION("DELIVERY_REPLY_DESCRIPTION"),
    APPROVAL_DESCRIPTION("APPROVAL_DESCRIPTION"),
    /**
     * 对应底部按钮
     */
    CONTENT_QUERY_BUTTON("CONTENT_QUERY_BUTTON"),

    /**
     * 可编辑：对应单行文本录入
     * 不可编辑：对应label组件
     */
    INPUT("INPUT"),
    /**
     * FRC定制文本录入框
     */
    CUST_FRC_GENERAL_WINDOW_STANDARD("CUST_FRC_GENERAL_WINDOW_STANDARD"),
    CUST_FRC_DEVICE_NAME("CUST_FRC_DEVICE_NAME"),
    /**
     * 金额输入框（本身应不可编辑）
     */
    AMOUNT_INPUT("AMOUNT_INPUT"),
    /**
     * 百分比录入框
     */
    PERCENT_INPUT("PERCENT_INPUT"),
    /**
     * 数值类型
     */
    MEASURE("MEASURE"),

    /**
     * 文本
     */
    LABEL("LABEL"),
    /**
     * 联系人
     */
    CONTACT("CONTACT"),
    /**
     * 地址
     */
    ADDRESS("ADDRESS"),
    /**
     * 附件 展示
     */
    FILE_UPLOAD("FILE_UPLOAD"),
    TASK_FILE_UPLOAD("TASK_FILE_UPLOAD"),

    /**
     * 名称id容器
     */
    NAME_CODE_COMPONENT("NAME_CODE_COMPONENT"),

    /**
     * 日期组件
     */
    DATEPICKER("DATEPICKER"),

    /**
     * 单选按钮
     */
    CHECKBOX("CHECKBOX"),

    /**
     * 图档
     */
    DYNAMIC_GRAPH_VIEWER("DYNAMIC_GRAPH_VIEWER"),
    /**
     * 数字类型
     */
    NUMERIC("numeric"),
    /**
     * 弹窗单选类型
     */
    BOOLEAN("boolean"),
    /**
     * 编排
     */
    OPERATION_EDITOR("OPERATION_EDITOR"),
    /**
     * 表单多选
     */
    FORM_OPERATION_EDITOR("FORM_OPERATION_EDITOR"),
    /**
     * 选择组件
     */
    SELECT("SELECT"),

    /**
     * 多行文本（layout是FORM时使用）
     */
    TEXTAREA("TEXTAREA"),

    STRING("string"),

    /**
     * 多行文本（layout是TABLE或ATHENA_TABLE时使用）
     */
    TEXTAREA_TEXT("TEXTAREA_TEXT"),
    /**
     * 级联组件（EOC定制）
     */
    EOC_SELECT("EOC_SELECT"),
    /**
     * 时间范围
     */
    DATE_RANGE("DATE_RANGE"),
    ;

    private String value;

    PcModuleEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static PcModuleEnum getEnumByName(String name) {
        String tester = name;
        for (PcModuleEnum pcModuleEnum :
                PcModuleEnum.values()) {
            if (pcModuleEnum.name().equalsIgnoreCase(tester)) {
                return pcModuleEnum;
            }
        }
        return null;
    }
}
