package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskProgress;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;

import java.util.List;

public interface UniversalParsingService {

    /**
     * 通用翻译逻辑，返回移动端可使用的UibotModel
     *
     * @param apiRequest
     * @param oldpageSetting
     * @param pcUiBotModel
     * @param digiwinAtmcBacklogDetail
     * @param digiwinAtmcTaskProgressList
     * @param reassignReportList
     * @return
     */
    UiBotModel buildPatternModel(ApiRequest apiRequest, PageSetting oldpageSetting,
                                 UiBotModel pcUiBotModel,
                                 DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                 List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList, List<DigiwinReassignReport> reassignReportList);

    /**
     * 标准pattern 构建展示任务标题，以及空组件提示
     *
     * @param taskModel
     * @param apiRequest
     * @return
     */
    UiBotModel buildShowTitleAndEmpty(UiBotModel taskModel, ApiRequest apiRequest);
}
