package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.*;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFill;
import com.digiwin.mobile.mobileuibot.core.component.basic.AutoFillData;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonRawData;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.search.SearchCategory;
import com.digiwin.mobile.mobileuibot.core.component.search.SkipConfig;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabscroll.TabScrollContainer;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorService;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorServiceResult;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.UniversalParsingService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailBizReport;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author wuyang
 * 通用解析类
 */
@Slf4j
@Service("universalParsingService")
public class UniversalParsingServiceImpl implements UniversalParsingService {

    /**
     * PC端CONTENT_QUERY_BUTTON对应的多页签的schema
     */
    private static final String TABS_SCHEMA = "tabs";
    /**
     * PC端头部的回复型数据
     */
    private static final String TITLE_REPLY_DATA = "titleDescription";
    /**
     * 移动端的滚动组件的schema
     */
    public static final String TABSCROLL_SCHEMA = "tabScroll";
    /**
     * 移动端的单层布局类型
     */
    private static final Integer PATTERN_TYPE_SINGLE = 1;
    /**
     * 移动端的多层布局类型
     */
    private static final Integer PATTERN_TYPE_DOUBLE = 2;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private LayoutGeneratorService layoutGeneratorService;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildPatternModel(ApiRequest apiRequest, PageSetting oldpageSetting, UiBotModel pcUiBotModel,
                                        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                        List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList,
                                        List<DigiwinReassignReport> reassignReportList) {
        List<String> targetLayoutTypeList = new ArrayList<>();
        // pc端会用到的布局类型
        targetLayoutTypeList.add(PcLayoutEnum.TABLE.getValue());
        targetLayoutTypeList.add(PcLayoutEnum.ATHENA_TABLE.getValue());
        targetLayoutTypeList.add(PcLayoutEnum.FORM_LIST.getValue());
        targetLayoutTypeList.add("SPLIT_LAYOUT");
        UiBotModel targetLayoutAndPageDataModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, Collections.emptyList(), false);

        Map<String, Object> preProcessDataBizDataMap = new HashMap<>(1);
        targetLayoutAndPageDataModel.getLayout().forEach(layout -> {
            String layoutSchemaKey = layout.getSchema();
            preProcessDataBizDataMap.put(layoutSchemaKey, pcUiBotModel.getPageData().get(layoutSchemaKey));
        });
        LayoutGeneratorPreprocessData preprocessData = LayoutGeneratorPreprocessData.builder()
                .renderVersion(MobileRenderMetaData.RENDER_VERSION_1)
                .apiRequest(apiRequest)
                .pcUiBotModel(pcUiBotModel)
                .bizDataMap(preProcessDataBizDataMap)
                .build();
        LayoutGeneratorServiceResult layoutGeneratorServiceResult = this.layoutGeneratorService.generate(preprocessData);
        UiBotModel resultMobileUiBotModel;
        // 根据不同布局，走不同的build逻辑
        if (Objects.equals(MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT, layoutGeneratorServiceResult.getLayoutTypeEnum())) {
            resultMobileUiBotModel = this.buildSinglePatternModel(apiRequest, oldpageSetting, layoutGeneratorServiceResult,
                    pcUiBotModel, digiwinAtmcBacklogDetail, digiwinAtmcTaskProgressList, reassignReportList);
        } else {
            resultMobileUiBotModel = this.buildDoublePatternModel(apiRequest, oldpageSetting, layoutGeneratorServiceResult,
                    pcUiBotModel, digiwinAtmcBacklogDetail, digiwinAtmcTaskProgressList, reassignReportList);
        }
        // 保存布局生成服务的处理结果
        resultMobileUiBotModel.setLayoutGeneratorServiceResult(layoutGeneratorServiceResult);
        // 保存与设计器处理相关的结果
        resultMobileUiBotModel.setAppliedDesignerFieldAndOrder(pcUiBotModel.getAppliedDesignerFieldAndOrder());
        resultMobileUiBotModel.setAppliedDesignerFieldTag(pcUiBotModel.getAppliedDesignerFieldTag());
        resultMobileUiBotModel.setAppliedDesignerFieldRule(pcUiBotModel.getAppliedDesignerFieldRule());
        resultMobileUiBotModel.setAppliedDesignerFieldOperation(pcUiBotModel.getAppliedDesignerFieldOperation());
        return resultMobileUiBotModel;
    }

    @Override
    public UiBotModel buildShowTitleAndEmpty(UiBotModel uiBotModel, ApiRequest apiRequest) {
        LayoutGeneratorServiceResult layoutGeneratorServiceResult = uiBotModel.getLayoutGeneratorServiceResult();
        if (null == layoutGeneratorServiceResult) {
            return uiBotModel;
        }
//        // 根据不同布局，走不同的build逻辑
//        if (Objects.equals(MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT, layoutGeneratorServiceResult.getLayoutTypeEnum())) {
//            // 单层
//            uiBotModel.buildShowTitleAndEmpty(localeService, apiRequest.getLocale());
//        } else {
//            // 多层
//            uiBotModel.buildShowTitleAndEmpty(localeService, apiRequest.getLocale());
//        }
        uiBotModel.buildShowTitleAndEmpty(localeService, apiRequest.getLocale());
        return uiBotModel;
    }

    private UiBotModel buildSinglePatternModel(ApiRequest apiRequest, PageSetting oldPageSetting,
                                               LayoutGeneratorServiceResult layoutGeneratorServiceResult, UiBotModel pcUiBotModel,
                                               DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                               List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList,
                                               List<DigiwinReassignReport> reassignReportList) {
        List<UiBotLayout> pcLayouts = pcUiBotModel.getLayout();
        List<UiBotLayout> mobileLayouts = new ArrayList<>(pcLayouts.size());
        UiBotModel mobileUiBotModel = new UiBotModel(mobileLayouts);
        UiBotPageData mobilePageData = new UiBotPageData();
        mobileUiBotModel.setPageData(mobilePageData);

        boolean headHasEdit = false;

        String locale = apiRequest.getLocale();
        for (UiBotLayout pcLayout : pcLayouts) {
            String type = pcLayout.getType();
            String schema = pcLayout.getSchema();
            UiBotLayout mobileLayout = new UiBotLayout();

            if (type.equals(PcModuleEnum.ACTIVITY_TITLE.getValue())
                    || type.equals(PcModuleEnum.DELIVERY_REPLY_TITLE.getValue())) {
                // 头部1：任务标题
                UiBotLayout findLayout = UiBotModel.getApprovalDesriptionLayout(pcUiBotModel.getLayout());
                MobileComponent mobileComponent;
                if (findLayout != null) {
                    Map<String, Object> data = (Map<String, Object>) pcUiBotModel.getPageData().get(findLayout.getSchema());
                    mobileComponent = TitleBody.createApc(locale, digiwinAtmcBacklogDetail, findLayout, data);
                } else {
                    mobileComponent = ModuleUtils.buildTitle(pcUiBotModel,
                            (Map<String, Object>) pcUiBotModel.getPageData().get(schema),
                            digiwinAtmcBacklogDetail, apiRequest, false, false);
                }
                mobileLayout.setType(mobileComponent.returnComponentType());
                mobileLayout.setSchema(schema);
                mobilePageData.put(schema, mobileComponent);
                mobileLayouts.add(mobileLayout);

                ModuleUtils.addEmptyArea(mobileLayouts, mobilePageData);
            } else if (type.equals(PcLayoutEnum.FORM_LIST.getValue())) {
//                UiBotLayout tableLayout = ModuleUtils.getAthenaTableByFormList(pcLayout);
                Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(pcLayout.getSchema());
                if (CollectionUtils.isEmpty(bizData)) {
                    continue;
                }
                headHasEdit = ModuleUtils.uibotFormListLayoutHasEdit(pcLayout);
                MobileComponent mobileComponent = ModuleUtils.buildFormList(pcLayout, bizData,
                        pcUiBotModel.getExecuteContext(), apiRequest.getLocale(), "",
                        pcUiBotModel.getRules(), headHasEdit, true, true, apiRequest.getIamUserToken());
                mobileLayout.setType(mobileComponent.returnComponentType());
                mobileLayout.setSchema(schema);
                mobilePageData.put(schema, mobileComponent);
                mobileLayouts.add(mobileLayout);
            } else if (type.equals(PcLayoutEnum.ATHENA_TABLE.getValue())) {
                TaskDetailBizReport taskDetailBizReport = new TaskDetailBizReport(this.localeService);
                // 因为是TABLE类型的layout，所以数据一定是数组
                List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
                if (CollectionUtils.isEmpty(bizDataList)) {
                    continue;
                }

                List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcLayout.getColumnDefs();
                if (CollectionUtils.isEmpty(tableColumnDefinitionList)) {
                    continue;
                }
//                List<UiBotTableScriptFilter> scriptFilterList = pcLayout.getScriptFilters();

                // 分解出明细数据一行的字段列表
                List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(tableColumnDefinitionList);

                // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
                List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

                List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

                // 是否团队任务。若是，则所有可操作的按钮都不展示
                boolean taskInReadOnlyMode = apiRequest.getRawData().getBooleanValue("isTeamTask");
                if (!taskInReadOnlyMode) {
                    // 所有字段上方任务的快捷操作（如AUTO_FILL组件）
                    JSONArray operations = pcLayout.getOperations();
                    if (!CollectionUtils.isEmpty(operations)) {
                        List<AutoFillData> autoFillDataList = new LinkedList<>();
                        String reportAtOnceName = this.localeService.getLanguageValue(locale, "一键报工");
                        for (int i = 0; i < operations.size(); i++) {
                            // FIXME 后续接上KM的话，这里使用中文匹配的做法就要改，不然会有问题 by mowj 20220117
                            String title = operations.getJSONObject(i).getString("title").trim();
                            if (Objects.equals(title, reportAtOnceName)) {
                                autoFillDataList.add(AutoFillData.create(reportAtOnceName, pcLayout, bizDataList.get(0), Collections.emptyMap()));
                            }
                        }

                        if (!CollectionUtils.isEmpty(autoFillDataList)) {
                            AutoFill autoFill = new AutoFill();
                            autoFill.setData(autoFillDataList);
                            taskDetailBizReport.addMobileComponent(0, autoFill);
                        }
                    }
                }
                // TODO PCC手动报工任务引起的功能，先注释掉了。后面需要再看如何调整
//                pcUiBotModel.getVariableMaps().put("progressCancel", digiwinKnowledgeMapsProxyService.getVariable(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), "progressCancel"));
                for (Map<String, Object> bizData : bizDataList) {
                    if (TaskStringUtil.CUSTOM_TASK_CODE_CLOUD_STEWARD_REPORT
                            .equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmActivityId())
                            && TaskStringUtil.CUSTOM_PROJECT_CODE_CLOUD_STEWARD_REPORT.equalsIgnoreCase(digiwinAtmcBacklogDetail.getTmTaskId())) {
                        String taskNo = bizData.get("task_no").toString();
                        String projectNo = bizData.get("project_no").toString();
                        //todo 应用方api卡控获取前置任务状态都已完成才可100%提交的校验，本次S6无法支持，在S8才可以支持  后续这块逻辑得去掉
                        List<String> taskStatusList = digiwinEspProxyService.getTaskPiscInfo(apiRequest.getIamUserToken(), projectNo, taskNo, apiRequest.getTenantId(), apiRequest.getLocale());
                        if (CollUtil.isNotEmpty(taskStatusList)) {
                            //获取前置任务 如果有一个task_status不是30，那就不能100%报工
                            boolean b = taskStatusList.stream().allMatch(a -> a.equalsIgnoreCase("30"));
                            //是否可报工
                            pcUiBotModel.getVariableMaps().put("isReportableWork", b);
                        }
                        JSONArray jsonArray = new JSONArray();
                        JSONObject jsonObject1 = new JSONObject();
                        jsonObject1.put("variableId", "overdue_report");
                        JSONObject jsonObject2 = new JSONObject();
                        jsonObject2.put("variableId", "overdue_report_day");
                        jsonArray.add(jsonObject1);
                        jsonArray.add(jsonObject2);
                        List<Map<String, Object>> mechanismVariableList = digiwinKnowledgeMapsProxyService.getMechanismVariableList(apiRequest.getIamUserToken(),
                                apiRequest.getTenantId(), apiRequest.getLocale(), jsonArray);
                        if (CollUtil.isNotEmpty(mechanismVariableList)) {
                            for (Map<String, Object> map : mechanismVariableList) {
                                //获取逾期报工开关
                                if ("overdue_report".equalsIgnoreCase(map.get("variableId").toString())) {
                                    pcUiBotModel.getVariableMaps().put("overdue_report", map.get("result"));
                                }
                                //获取可逾期天数（天）
                                if ("overdue_report_day".equalsIgnoreCase(map.get("variableId").toString())) {
                                    pcUiBotModel.getVariableMaps().put("overdue_report_day", map.get("result"));
                                }
                            }
                        }
                        //是否需要交付物，v1转v2前端规则使用。
                        pcUiBotModel.getVariableMaps().put("is_attachment", bizData.get("is_attachment"));
                        //计划结束日期
                        pcUiBotModel.getVariableMaps().put("plan_finish_date", bizData.get("plan_finish_date"));
                        mobileUiBotModel.getPageData().put("task_info", pcUiBotModel.getVariableMaps());
                        mobileUiBotModel.setRawUiBotPageData(mobileUiBotModel.getPageData());

                        tableColumns.forEach(column -> {
                            // 体系云项目编号, 项目名称, 项目负责人, 任务说明 不可编辑
                            if(Lists.newArrayList("project_no", "project_name", "project_leader_name", "attachment_remark").contains(column.getSchema())){
                                column.setEditable(false);
                            }
                        });
                    }

                    taskDetailBizReport.addMobileComponentsByColumnAndBizData(
                            locale, tableColumns, pcUiBotModel, bizData,
                            digiwinAtmcBacklogDetail, mobileRuleList, columnTagList, apiRequest);
                }
                mobileUiBotModel.getLayout().addAll(taskDetailBizReport.getActualLayoutList());
                mobileUiBotModel.getPageData().putAll(taskDetailBizReport);
                //录入页面卡片化设置
                mobileUiBotModel.setCustomGroup();
            }
        }

        /**
         * 按钮生成
         */
        // 获得实际业务的数据对象：layout中schema=id的那个layout，schema就是。
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        Object bizData = pcUiBotModel.getPageData().get(bizDataSchema);
        if (CollectionUtils.isEmpty(pcUiBotModel.getActions())) {
            return this.buildEmptyContentModel(locale, mobileUiBotModel);
        }
        if (bizData instanceof Collection) {
            if (CollectionUtils.isEmpty((Collection<?>) bizData)) {
                return this.buildEmptyContentModel(locale, mobileUiBotModel);
            }
        } else if (bizData instanceof Map) {
            if (CollectionUtils.isEmpty((Map) bizData)) {
                return this.buildEmptyContentModel(locale, mobileUiBotModel);
            }
        } else {
            if (Objects.isNull(bizData)) {
                return this.buildEmptyContentModel(locale, mobileUiBotModel);
            }
        }

        // 依PCUiBot的内容，构造移动端底部操作按钮（因操作上pc和移动相同，所以可以直接用pc的）
        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        BottomButtonList bottomButtonList = new BottomButtonList();

        UiBotModel pageSettingModel = oldPageSetting.getPageModel();
        String bottomButtonDataSchema = pageSettingModel.getLayout().stream().filter(
                layout -> layout.getType().equalsIgnoreCase(BottomButtonDigiwinAthena.COMPONENT_TYPE)
        ).findFirst().orElse(new UiBotLayout()).getSchema();

        Map<String, Object> pageData = pageSettingModel.getPageData();
        JSONArray bottomButtonDataArray =
                (JSONArray) JSON.toJSON(pageData.get(bottomButtonDataSchema));
        if (CollectionUtils.isEmpty(bottomButtonDataArray)) {
            for (UiBotAction uiBotAction : uiBotActions) {
                BottomButtonDigiwinAthena bottomButton;
                bottomButton = BottomButtonDigiwinAthena.create(uiBotAction,
                        bizDataSchema, bizData, null, new Action(ActionTypeEnum.CALL_API.getValue()));

                Object oldRawData = bottomButton.getAction().getRawData();
                if (oldRawData instanceof ButtonRawData) {
                    ButtonRawData oldBtnRawData = (ButtonRawData) oldRawData;
                    oldBtnRawData.setMobileLayoutType(MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT);
                }
                bottomButtonList.add(bottomButton);
            }
        }
        bottomButtonList.sort(Comparator.comparing(BottomButtonDigiwinAthena::getType).reversed());
        UiBotLayout bottomButtonLayout = new UiBotLayout();
        bottomButtonLayout.setType("BOTTOM_BUTTON");
        bottomButtonLayout.setSchema("bottomButtons");
        mobilePageData.put("bottomButtons", bottomButtonList);
        mobileLayouts.add(bottomButtonLayout);

        // 返回数据前的全局样式处理
        mobileUiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());

        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = mobileUiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK",
                    59096));
        }
        return this.buildEmptyContentModel(locale, mobileUiBotModel);
    }

    /**
     * 构建空组件
     *
     * @param locale
     * @param mobileUiBotModel
     * @return
     */
    private UiBotModel buildEmptyContentModel(String locale, UiBotModel mobileUiBotModel) {
        boolean existOther = mobileUiBotModel.getLayout().stream()
                .anyMatch(layout -> !(BlankArea.COMPONENT_TYPE.equals(layout.getType())
                        || TitleBody.COMPONENT_TYPE.equals(layout.getType())));
        if (existOther) {
            return mobileUiBotModel;
        }
        // 创建空组件
        UiBotModel empty = UiBotModel.createEmptyComponent(
                localeService.getLanguageValue(locale, "暂无数据"),
                false,
                null);
        mobileUiBotModel.getLayout().addAll(empty.getLayout());
        mobileUiBotModel.getPageData().putAll(empty.getPageData());
        return mobileUiBotModel;
    }

    public UiBotModel buildDoublePatternModel(ApiRequest apiRequest, PageSetting oldPageSetting,
                                              LayoutGeneratorServiceResult layoutGeneratorServiceResult, UiBotModel pcUiBotModel,
                                              DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                              List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList,
                                              List<DigiwinReassignReport> reassignReportList) {
//        // 定制任务详情用空状态组件做提示
//        if (Boolean.TRUE.equals(pcUiBotModel.searchPcTargetLayout().getHasCustomData())) {
//            String msg = this.localeService.getLanguageValue(apiRequest.getLocale(), "APP端暂不支持该定制任务，请到Web端查看");
//            return UiBotModel.emptyUiBotModel().createEmptyContentModel(msg);
//        }
        List<UiBotLayout> pcUiBotModelLayouts = pcUiBotModel.getLayout();
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(pcUiBotModelLayouts.size());
        UiBotModel uiBotModel = new UiBotModel(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        Integer patternType = judgePatternType(pcUiBotModel);
        UiBotLayout tabScrollLayout = new UiBotLayout();
        tabScrollLayout.setType(TabScrollContainer.COMPONENT_TYPE);
        tabScrollLayout.setSchema(TABSCROLL_SCHEMA);
        TabScrollContainer tabScrollContainer = new TabScrollContainer();
        List<CustomTabContentContainer> headArea = tabScrollContainer.getHeadArea();
        List<CustomTabContentContainer> bodyArea = tabScrollContainer.getBodyArea();
        Boolean headHasEdit;
        Boolean hasTitle = true;
        if (!ModuleUtils.uibotIsNotEmpty(pcUiBotModel)) {
            bodyArea.add(CustomTabContentContainer.emptyContainer(apiRequest.getLocale()));
        } else {
            //只有当其为多层布局时才解析 todo 暂时不分单双层布局
//        if (patternType.equals(PATTERN_TYPE_DOUBLE)) {
            for (UiBotLayout pcUiBotModelLayout : pcUiBotModelLayouts) {
                String type = pcUiBotModelLayout.getType();
                String schema = pcUiBotModelLayout.getSchema();
                UiBotLayout uiBotLayout = new UiBotLayout();
                //头部1
                if (type.equals(PcModuleEnum.ACTIVITY_TITLE.getValue())) {
                    hasTitle = false;
                    uiBotLayout.setType(TitleBody.COMPONENT_TYPE);
                    uiBotLayout.setSchema(schema);
                    pageData.put(schema, ModuleUtils.buildTitle(pcUiBotModel,
                            (Map<String, Object>) pcUiBotModel.getPageData().get(schema),
                            digiwinAtmcBacklogDetail, apiRequest, false, false));
                    uiBotLayouts.add(uiBotLayout);
                    ModuleUtils.addEmptyArea(uiBotLayouts, pageData);
                    //头部2
                } else if (type.equals(PcModuleEnum.DELIVERY_REPLY_TITLE.getValue())) {
                    uiBotLayout.setType(TitleBody.COMPONENT_TYPE);
                    uiBotLayout.setSchema(schema);
                    pageData.put(schema, ModuleUtils.buildTitle(pcUiBotModel,
                            (Map<String, Object>) pcUiBotModel.getPageData().get(schema),
                            digiwinAtmcBacklogDetail, apiRequest, true, false));
                    uiBotLayouts.add(uiBotLayout);
                    if (hasTitle) {
                        hasTitle = false;
                        ModuleUtils.addEmptyArea(uiBotLayouts, pageData);
                    }
                    //描述名称
                } else if (type.equals(PcModuleEnum.DELIVERY_REPLY_DESCRIPTION.getValue())) {
                    uiBotLayout.setType(CustomGroup.COMPONENT_TYPE);
                    uiBotLayout.setSchema(TITLE_REPLY_DATA);
                    pageData.put(TITLE_REPLY_DATA, ModuleUtils.buildReplyTitle(pcUiBotModelLayout,
                            (Map<String, Object>) pcUiBotModel.getPageData().get(schema), apiRequest));
                    uiBotLayouts.add(uiBotLayout);
                    ModuleUtils.addEmptyArea(uiBotLayouts, pageData);
                    //单头
                } else if (type.equals(PcModuleEnum.APPROVAL_DESCRIPTION.getValue())) {
                    headHasEdit = ModuleUtils.uibotFormListLayoutHasEdit(pcUiBotModelLayout);
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                    container.setData(ModuleUtils.buildFormList(pcUiBotModelLayout,
                            (Map<String, Object>) pcUiBotModel.getPageData().get(schema),
                            pcUiBotModel.getExecuteContext(), apiRequest.getLocale(),
                            "", pcUiBotModel.getRules(), headHasEdit, true, true, apiRequest.getIamUserToken()));
                    headArea.add(container);
                    if (headHasEdit) {
                        BottomButtonList buttonList = new BottomButtonList();
                        CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
                        buttonContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                        Map<String, Object> rawData = new HashMap<>();
                        rawData.put("dataId", apiRequest.getDataId());
                        rawData.put("tmTaskId", apiRequest.getExtraParameter().getTmTaskId());
                        rawData.put("tmActivityId", apiRequest.getExtraParameter().getTmActivityId());
                        rawData.put("rawData", apiRequest.getRawData());
                        rawData.put("isTabs", false);
                        buttonList.add(BottomButtonDigiwinAthena.createNextStepButton(apiRequest.getLocale(), rawData));
                        buttonContainer.setData(buttonList);
                        break;
                    }
                    //tab签
                } else if (type.equals(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue())) {
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(CustomTabController.COMPONENT_TYPE);
                    container.setData(ModuleUtils.buildTabs(pcUiBotModel, apiRequest, digiwinAtdmProxyService));
                    bodyArea.add(container);

                    break;
                }

            }
//        }
        }
        uiBotLayouts.add(tabScrollLayout);
        pageData.put(TABSCROLL_SCHEMA, tabScrollContainer);
        uiBotModel.setPageData(pageData);

        uiBotModel = buildSlip(apiRequest, pcUiBotModel, uiBotModel, digiwinAtmcBacklogDetail);

        if (digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(digiwinAtmcBacklogDetail.getId() + "",
                    buttonActionRawData, apiRequest.getLocale(), "TASK",
                    59096));
        }
        List<UiBotLayout> layouts = uiBotModel.getLayout();
        Map<String, Object> commonRawData = uiBotModel.getCommonRawData();
        commonRawData.put("layout", ModuleUtils.getAthenaTable(pcUiBotModelLayouts));
        commonRawData.put("pageData", pcUiBotModel.getPageData());
        commonRawData.put("executeContext", pcUiBotModel.getExecuteContext());
        commonRawData.put("rules", pcUiBotModel.getRules());
        commonRawData.put("action", ModuleUtils.getDefaultAction(pcUiBotModel));
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    /**
     * 判断单双层类型
     * 1:先判断整个有没有ATHENA_TABLE
     * A--没有,则是单层
     * B--有,则判断表格数据是否大于1条
     * 大于则是双层
     * 小于等于则进入2
     * 2:判断有没有CONTENT_QUERY_BUTTON
     * A--没有则是单层
     * B--有则button判断是否大于1个
     * 大于则是双层
     * 小于等于则进入3
     * 3:判断rowSize是否大于1
     * 大于则是双层
     * 小于等于则是单层
     * TODO 可在优化一下写法
     *
     * @param pcUiBotModel
     * @return
     */
    private Integer judgePatternType(UiBotModel pcUiBotModel) {
        //首先看有没有table组件
        List<String> tableTargetLayoutTypeList = new ArrayList<>();
        tableTargetLayoutTypeList.add(PcLayoutEnum.ATHENA_TABLE.getValue());
        List<String> tableParentLayoutTypeList = new ArrayList<>();
        tableParentLayoutTypeList.add(PcLayoutEnum.FORM_LIST.getValue());
        UiBotModel tableUiBotModel = pcUiBotModel.searchPcTargetModel(tableTargetLayoutTypeList, tableParentLayoutTypeList, false);
        if (!CollectionUtils.isEmpty(tableUiBotModel.getLayout())) {
            List<UiBotLayout> layouts = tableUiBotModel.getLayout();
            UiBotPageData pageData = tableUiBotModel.getPageData();
            for (UiBotLayout layout : layouts) {
                Object bizData = new Object();
                //拿到table的pageData
                if (layout.getSchema().contains(".")) {
                    String[] schemas = layout.getSchema().split("\\.");
                    Map<String, Object> map = new HashMap<>();
                    for (String tableSchema : schemas) {
                        if (map.get(tableSchema) instanceof List) {
                            bizData = map.get(tableSchema);
                        } else if (map.get(tableSchema) instanceof Map) {
                            map = (Map<String, Object>) map.get(tableSchema);
                        } else {
                            if (pageData.get(tableSchema) instanceof Map) {
                                map = (Map<String, Object>) pageData.get(tableSchema);
                            }
                        }

                    }
                } else {
                    bizData = pageData.get(layout.getSchema());
                }

                if (bizData instanceof List) {
                    if (((List) bizData).size() > 2) {
                        return PATTERN_TYPE_DOUBLE;
                    } else {
                        UiBotLayout uiBotLayout = UiBotModel.getContentQueryButtonLayout(pcUiBotModel.getLayout());
                        if (uiBotLayout != null) {
                            List<UiBotQueryButton> queryButtons = uiBotLayout.getQueryButtons();
                            if (queryButtons.size() > 1) {
                                return PATTERN_TYPE_DOUBLE;
                            } else {
                                if (queryButtons.get(0) != null && queryButtons.get(0).getRowSize() > 1) {
                                    return PATTERN_TYPE_DOUBLE;
                                } else {
                                    return PATTERN_TYPE_SINGLE;
                                }
                            }
                        }
                        return PATTERN_TYPE_SINGLE;
                    }
                }
            }
        } else {
            return PATTERN_TYPE_SINGLE;
        }
        return PATTERN_TYPE_SINGLE;
    }

    /**
     * 构建左右滑
     *
     * @param apiRequest
     * @param pcUiBotModel
     * @param model
     * @param digiwinAtmcBacklogDetail
     * @return
     */
    private UiBotModel buildSlip(ApiRequest apiRequest, UiBotModel pcUiBotModel, UiBotModel model, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        // 此处用Athena后端数据与IM群聊扩展字段的bizId对比后发现，需要使用bpmActivityId才可以找到对应群聊
        if (null != digiwinAtmcBacklogDetail.getBpmActivityId()) {
            model.setDataId(digiwinAtmcBacklogDetail.getBpmActivityId());
        }
        // 左右滑页面的标题处理
        String athenaTaskName = Optional.ofNullable(digiwinAtmcBacklogDetail).map(DigiwinAtmcBacklogDetail::getName).orElse("");
        if (!StringUtils.hasLength(athenaTaskName)) {
            athenaTaskName = String.valueOf(pcUiBotModel.getPageData().getUiBotActivity().get("name"));
        }

        UiBotSlip slip = new UiBotSlip();
        slip.setSlipType(SlipTypeEnum.LEFT_AND_RIGHT_SLIP.getValue());
        SlipConfig slipConfig = new SlipConfig();
        //构造右滑摇人
        slipConfig.setLeft(SlipConfigLeft.build(apiRequest.getLocale(), athenaTaskName));
        SlipConfigLeft left = slipConfig.getLeft();
        //先查EOC、IAM等账号信息（不包含邮箱、手机号等）
        List<DigiwinAtmcProjectPerformer> projectPerformers = digiwinAtmcProxyService.getPerformerListByBackLogId(digiwinAtmcBacklogDetail.getBacklogId(),
                apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        //在查邮箱、手机号等信息
        EocPersonResponse eocPersonResponse = digiwinEocProxyService.getSimplePersonList(
                apiRequest.getIamUserToken(), 9999, 1, "");
        SlipConfigLeft.setPersonList(left, projectPerformers, eocPersonResponse);


        //这边需要传递点参数给左滑辅助资讯
        SlipConfigRight right = new SlipConfigRight();
        //左滑标题
        right.setTitle(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "辅助资讯"));
        //左滑的头部
        LeftHeader header = new LeftHeader();
        header.setShowHeader(true);
        SlipTitle leftSlipTitle = new SlipTitle();
        leftSlipTitle.setContent(athenaTaskName);
        leftSlipTitle.setPrefix(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "根据您当前事务"));
        leftSlipTitle.setSuffix(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "的处理"));
        List<String> newLine = new ArrayList<>(1);
        newLine.add(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "系统匹配了以下资讯"));
        leftSlipTitle.setNewLine(newLine);
        header.setSubTitle(leftSlipTitle);
        right.setHeader(header);
        //左滑的底部
        LeftFooter leftFooter = new LeftFooter();
        leftFooter.setTitle(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "资讯不够，想知道更多？"));
        leftFooter.setShowFooter(true);
        List<ComponentBox> componentBoxes = new ArrayList<>(1);
        ComponentBox componentBox = new ComponentBox();
        componentBox.setData(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "搜索你想知道的内容"));
        componentBox.setPosition(0);
        SkipConfig skipConfig = new SkipConfig();
        skipConfig.setJumpUrl("/mobile/v1/search/globalSearch");
        skipConfig.setRequestType(2);
        componentBox.setJumpConfig(skipConfig);
        componentBox.setComponentType("SEARCH_BOX");
        List<SearchCategory> searchCategories = new ArrayList<>(4);
        searchCategories.add(SearchCategory.build("all",
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "全部")));
        searchCategories.add(SearchCategory.build("all",
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "项目")));
        searchCategories.add(SearchCategory.build("all",
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "任务")));
        searchCategories.add(SearchCategory.build("all",
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "问题")));
        componentBox.setSearchCategories(searchCategories);
        componentBoxes.add(componentBox);
        leftFooter.setComponentBox(componentBoxes);
        right.setFooter(leftFooter);
        //左滑的中间组件 TODO 跳转的参数，暂未想好该如何处理
        LeftBody leftBody = new LeftBody();
        leftBody.setShowBody(true);
        SkipConfig jumpConfig = new SkipConfig();
        jumpConfig.setJumpUrl("/mobile/v1/uibot/model");
        jumpConfig.setPageId(PageSettingIdPresetEnum.MOBILE_LEFT_SLIP.toString());
        jumpConfig.setRequestType(2);
        leftBody.setJumpConfig(jumpConfig);
        right.setBody(leftBody);
        slipConfig.setRight(right);
        slip.setSlipConfig(slipConfig);

        model.setSlip(slip);
        return model;
    }
}