package com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.common.SizeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.*;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.Postmark;
import com.digiwin.mobile.mobileuibot.core.component.card.statistic.StatisticCard;
import com.digiwin.mobile.mobileuibot.core.component.chart.*;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartcoordinate.ChartCoordinate;
import com.digiwin.mobile.mobileuibot.core.component.chart.chartseries.ChartSeries;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendar;
import com.digiwin.mobile.mobileuibot.core.component.input.calendar.InputCalendarTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.*;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.workflowprogress.WorkflowProgress;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.MobileColumn;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcLayoutEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanelTask;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDsl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataShowCategoryEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.ChartRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

public class ModuleUtils {

    /**
     * 控制显示隐藏的按钮数量
     */
    public static final Integer BUTTON_MORE_SIZE = 3;
    /**
     * 控制显示隐藏的字段数量
     */
    public static final Integer FILED_MORE_SIZE = 5;
    /**
     * 只显示只读字段数量
     */
    public static final Integer ONLY_READ_FILED_SIZE = 4;
    public static final String YES = "Y";
    public static final String NO = "N";

    /**
     * 底部按钮的schema
     */
    private static final String BOTTOM_BUTTON_SCHEMA = "button";
    /**
     * 图表的布局type
     */
    private static final String TYPE_FLEX = "FLEX";
    /**
     * 空区域的schema
     */
    private static final String BLANK_AREA_SCHEMA = "blankArea";

    public static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

    /**
     * 从敏捷数据组件的中间态DSL生成移动端组件信息
     *
     * @param request         前端请求
     * @param intermediateDsl 中间态DSL
     * @param inAiAssistant   是否在智能助理中使用
     * @return 移动端组件数据清单
     */
    public static List<MobileComponent> generateComponentFromAgileDataIntermediateDsl(
            ApiRequest request, AgileDataIntermediateDsl intermediateDsl, boolean inAiAssistant) {
        Optional<AgileDataIntermediateLayout> optLayout = intermediateDsl.getLayout()
                .stream()
                .filter(l -> "DSL_MOBILEPLATFORM_PAGEDEFINE".equals(l.getType().toUpperCase()))
                .findFirst();
        if (!optLayout.isPresent()) {
            return Collections.emptyList();
        }
        AgileDataIntermediateLayout intermediateLayout = optLayout.get();
        intermediateLayout.init();
        List<AgileDataIntermediateDataItem> intermediateDataItems = intermediateLayout.getSortedDataItems();

        List<MobileComponent> mobileComponents = new ArrayList<>(intermediateDataItems.size());
        /**
         * 由于PC的报表布局是用户自己拖拉定义的，在数据源上没办法给到顺序，所以移动按照接口给到的数组顺序作为展示顺序
         * 内嵌规则：
         * 1. 不在智能助理中使用时：有且仅当只有一个表格时，不会出现收起展开功能
         * 2. 在智能助理中使用时：表格默认出现收起展开功能
         */
        long tableCount = intermediateDataItems.stream()
                .filter(d -> AgileDataShowCategoryEnum.TABLE.getValue().equals(d.getShowCategory()))
                .count();
        boolean tableUseCollapse = !(tableCount == 1 && tableCount == intermediateDataItems.size());
        boolean tableNeedFilterAndSort = true;
        if (inAiAssistant) {
            tableUseCollapse = true;
            tableNeedFilterAndSort = false;
        }

        for (AgileDataIntermediateDataItem intermediateDataItem : intermediateDataItems) {
            intermediateDataItem.setDataTipMessage(intermediateDsl.getDataTipMessage());
            if (Objects.equals(AgileDataShowCategoryEnum.TABLE.getValue(), intermediateDataItem.getShowCategory())) {
                // 表格呈现
                mobileComponents.add(buildTable(intermediateDataItem, request.getLocale(), tableUseCollapse,
                        tableNeedFilterAndSort, intermediateDsl.getExecuteContext()));
            } else if (Objects.equals(AgileDataShowCategoryEnum.CHART.getValue(), intermediateDataItem.getShowCategory())) {
                // 图表呈现
                mobileComponents.add(buildChart(request.getLocale(), intermediateDataItem));
            } else if (Objects.equals(AgileDataShowCategoryEnum.STATISTIC.getValue(), intermediateDataItem.getShowCategory())) {
                // 统计指标合并
                mobileComponents.add(buildStatistic(request.getLocale(), intermediateDataItem));
            }
        }
        return mobileComponents;
    }

    /**
     * 中间态DSL构建统计指标卡组件
     *
     * @param locale
     * @param statisticDataItem
     * @return
     */
    private static MobileComponent buildStatistic(String locale, AgileDataIntermediateDataItem statisticDataItem) {
        return StatisticCard.create(locale, statisticDataItem);
    }


    /**
     * 中间态DSL构建表格组件
     *
     * @param intermediateDataItem
     * @param locale
     * @param useCollapse
     * @param needFilterAndSort
     * @param executeContext
     * @return
     */
    private static MobileComponent buildTable(AgileDataIntermediateDataItem intermediateDataItem,
                                              String locale, boolean useCollapse, boolean needFilterAndSort,
                                              UiBotExecuteContext executeContext) {
        Table table = Table.create(locale, intermediateDataItem, useCollapse,
                localeService.getLanguageValue(locale, "查看更多"), needFilterAndSort, true,
                executeContext);
        return table;
    }

    /**
     * Uibot开窗构建表格
     *
     * @param uiBotLayout
     * @param pageData
     * @param executeContext
     * @param locale
     * @param useCollapse
     * @return
     */
    public static MobileComponent buildTable(UiBotLayout uiBotLayout, UiBotPageData pageData,
                                             UiBotExecuteContext executeContext, String locale,
                                             Boolean useCollapse) {
        Table table = Table.create(uiBotLayout, pageData, executeContext, locale, useCollapse);
        return table;
    }

    /**
     * 中间态DSL构建图表组件
     *
     * @param locale
     * @param intermediateDataItem
     * @return
     */
    private static MobileComponent buildChart(String locale,
                                              AgileDataIntermediateDataItem intermediateDataItem) {
        ChartRenderSetting chartRenderSetting = intermediateDataItem.getChartRenderSetting();
        String chartType = chartRenderSetting.getChartType();
        ChartTypeEnum chartTypeEnum = ChartTypeEnum.getEnumByValue(chartType);

        // 观察数据集
        intermediateDataItem.observeDataForChart(locale);
        // 对齐所有统计轴数量
        intermediateDataItem.alignChartValueAxesScaleCount();

        BaseMobileComponent chart = null;
        if (chartTypeEnum != null) {
            switch (chartTypeEnum) {
                case LINE:
                    chart = new LineChart()
                            .setBasic(ChartBasic.buildChartBasic(intermediateDataItem))
                            .setCoordinate(ChartCoordinate.buildChartCoordinate(intermediateDataItem, chartTypeEnum))
                            .setSeries(ChartSeries.buildLineChartSeries(locale, intermediateDataItem, chartTypeEnum));
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                case BAR:
                    chart = new BarChart()
                            .setBasic(ChartBasic.buildChartBasic(intermediateDataItem))
                            .setCoordinate(ChartCoordinate.buildChartCoordinate(intermediateDataItem, chartTypeEnum))
                            .setSeries(ChartSeries.buildBarChartSeries(locale, intermediateDataItem, chartTypeEnum));
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                case LINE_BAR:
                    chart = new LineBarChart()
                            .setBasic(ChartBasic.buildChartBasic(intermediateDataItem))
                            .setCoordinate(ChartCoordinate.buildChartCoordinate(intermediateDataItem, chartTypeEnum))
                            .setSeries(ChartSeries.buildBarChartSeries(locale, intermediateDataItem, chartTypeEnum));
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                case SCATTER:
                    chart = new ScatterChart()
                            .setOptions(chartRenderSetting.getTitle(), chartRenderSetting.getOption());
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                case BUBBLE:
                    chart = new BubbleChart()
                            .setOptions(chartRenderSetting.getTitle(), chartRenderSetting.getOption());
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                case PIE:
                    chart = new PieChart()
                            .setBasic(ChartBasic.buildChartBasic(intermediateDataItem))
                            .setCoordinate(ChartCoordinate.buildChartCoordinate(intermediateDataItem, chartTypeEnum))
                            .setSeries(ChartSeries.buildPieChartSeries(locale, intermediateDataItem));
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    // FIXME 2023-Q4敏捷数据专项，移动端做环形图，故先手动设置内半径。
                    ((PieChart) chart).setInnerRadius(PieChart.CIRCLE_PIE_CHART_INNER_RADIUS);
                    break;
                case MIXED:
                    chart = new MixedChart()
                            .setBasic(ChartBasic.buildChartBasic(intermediateDataItem))
                            .setCoordinate(ChartCoordinate.buildChartCoordinate(intermediateDataItem, chartTypeEnum))
                            .setSeries(ChartSeries.buildMixedChartSeries(locale, intermediateDataItem, chartTypeEnum));
                    chart.setSchema(intermediateDataItem.getBizDataId());
                    break;
                default:
                    break;
            }
        }
        return chart;
    }

    /**
     * pc的标题转换为移动的标题
     * 例如：09/22 需完成签核 逾期 31天 南京**公司（测试区）
     *
     * @param pageData
     * @param backlogDetail
     * @param apiRequest
     * @return
     */
    public static MobileComponent buildTitle(UiBotModel uiBotModel, Map<String, Object> pageData,
                                             DigiwinAtmcBacklogDetail backlogDetail, ApiRequest apiRequest,
                                             Boolean useEocName, Boolean isApproval) {
        // V1版标题构建，isPostmark 即为 isApproval
        return buildTitle(uiBotModel, pageData, backlogDetail, apiRequest, useEocName, isApproval, isApproval);
    }

    public static MobileComponent buildTitle(UiBotModel uiBotModel, Map<String, Object> pageData,
                                             DigiwinAtmcBacklogDetail backlogDetail, ApiRequest apiRequest,
                                             Boolean useEocName, Boolean isApproval, Boolean isPostmark) {
        if (pageData == null) {
            return TitleBody.createEmpty();
        }

        //结束时间
        String endMonthDate = buildTime(pageData);

        String systemTip = LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "需完成");
        String taskName = (String) pageData.get("name");
        String approvalState = backlogDetail.getApprovalState();

        // 签核的还得从uiBot__activity获取逾期和倒计时时间，直接pageData获取不到
        String overdueDate = Optional.ofNullable(backlogDetail.getOverdueDate()).orElse(
                Optional.ofNullable((String) pageData.get("overdueDate")).orElse("")
        );
        if (!StringUtils.hasLength(overdueDate)) {
            overdueDate = Optional.ofNullable((String) ((Map<String, Object>) MapUtil.getOrDefault(pageData, "uiBot__activity", Collections.emptyMap())).get("overdueDate")).orElse("");
        }

        String remainTime = Optional.ofNullable(backlogDetail.getRemainTime()).orElse(
                Optional.ofNullable((String) pageData.get("remainTime")).orElse("")
        );
        if (!StringUtils.hasLength(remainTime)) {
            remainTime = Optional.ofNullable((String) ((Map<String, Object>) MapUtil.getOrDefault(pageData, "uiBot__activity", Collections.emptyMap())).get("remainTime")).orElse("");
        }
        boolean isOverdue = !overdueDate.isEmpty() && remainTime.isEmpty();

        //显示逾期等标签
        List<Tag> tags = new ArrayList<>();

        if (BooleanUtils.isTrue(isApproval)) {
            Map<String, Object> uiBotActivityData = (Map<String, Object>) pageData.get("uiBot__activity");
            endMonthDate = buildTime(uiBotActivityData);
            ;
            taskName = (String) uiBotActivityData.get("name");
            if (TaskStringUtil.isBizDataEntryDriven(backlogDetail.getTmPattern(), backlogDetail.getTmCategory())) {
                // tmPattern=BUSINESS、tmCategory=DATA_ENTRY_DRIVEN
                Tag approvalTag = Tag.createBabyBuleBgdBuleTextOnRightTag(
                        localeService.getLanguageValue(apiRequest.getLocale(), "流程进度"),
                        WorkflowProgress.buildAction(TaskDataExtractUtil.getWorkflowProgressRawData(JsonUtil.objectToJavaObject(pageData, UiBotPageData.class))),
                        1);
                tags.add(approvalTag);
            } else {
                Tag approvalTag = Tag.createBabyBuleBgdBuleTextOnRightTag(
                        LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString()),
                        Button.createApprovalProgressCheckButton(apiRequest.getLocale(),
                                        TaskDataExtractUtil.getSignoffProgressData(JsonUtil.objectToJavaObject(pageData, UiBotPageData.class)))
                                .getAction(),
                        1);
                tags.add(approvalTag);
            }
        }

        Tag timeHintTag =
                isOverdue ?
                        Tag.createWarningTag(
                                new StringBuilder(localeService.getLanguageValue(apiRequest.getLocale(), "逾期"))
                                        .append(overdueDate).toString()
                        )
                        :
                        Tag.createPromptTag(
                                new StringBuilder(localeService.getLanguageValue(apiRequest.getLocale(), "倒计时"))
                                        .append(remainTime).toString()
                        );
        tags.add(timeHintTag);

        // 任务状态标签
        if (StringUtils.hasLength(approvalState)) {
            Tag approvalStateTag = Tag.createBlueBgdWriteTextStateTag(approvalState);
            tags.add(approvalStateTag);
        }

        PageDesc pageDesc = new PageDesc();
        pageDesc.setTitle(backlogDetail.getName());
        //逾期
//        if (isOverdue) {
//            pageDesc.addContent(0xe66e, overdueDate, PageDescContentTypeEnum.ABNORMAL.getValue());
//        }
        if (BooleanUtils.isTrue(useEocName)) {
            List<String> eocNames = UiBotModel.getEocNames(JsonUtil.objectToJavaObject(pageData, UiBotPageData.class));
            //所属公司-工厂
            if (eocNames != null && eocNames.size() > 0) {
                //TODO 所属公司工厂 icon数据
                pageDesc.addContent(0xe68d, eocNames.get(0),
                        PageDescContentTypeEnum.NORMAL.getValue());
            }
        }

        // 任务表头问号里面增加显示
        String projectName = "";
        if (ObjectUtils.isNotEmpty(pageData.get("uiBot__activity"))) {
            Map<String, Object> uiBotActivity = (Map<String, Object>) pageData.get("uiBot__activity");
            projectName = ProjectStringUtil.getProjectNameOnCard(
                    apiRequest.getLocale(),
                    (String) uiBotActivity.get("taskStartTime"), (String) uiBotActivity.get("taskEndTime"),
                    (String) uiBotActivity.get("taskName"), false);
        }
        String overduePrefix = LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "已逾期") + "%s";
        if (StringUtils.hasLength(overdueDate)) {
            pageDesc.addContent(0xe66e, String.format(overduePrefix, overdueDate), PageDescContentTypeEnum.ABNORMAL.getValue());
        }
        if (StringUtils.hasLength(projectName)) {
            pageDesc.addContent(0xe673, projectName, PageDescContentTypeEnum.NORMAL.getValue());
        }

        TitleBody titleBody = TitleBody.create(endMonthDate + systemTip + " " + taskName,
                pageDesc, timeHintTag, tags);
        if (BooleanUtils.isTrue(isPostmark) && BooleanUtils.isTrue(uiBotModel.getFinished())) {
            titleBody.setPostmark(new Postmark(StringUtils.hasLength(uiBotModel.getFinishedTitle()) ? uiBotModel.getFinishedTitle() : "--"));
        }
        return titleBody;
    }

    private static String buildTime(Map<String, Object> data) {
        String endMonthDate = "";

        // 只有是合并任务卡且planEndTimeMin和planEndTimeMax不一致才展示时间区间，否则展示时间点
        String planEndTimeMin = MapUtils.getString(data, "planEndTimeMin");
        String planEndTimeMax = MapUtils.getString(data, "planEndTimeMax");
        if (BooleanUtils.isTrue(MapUtils.getBooleanValue(data, "merge")) && !Objects.equals(planEndTimeMin, planEndTimeMax)) {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(planEndTimeMin) + "-" + DateTimeUtil.getMonthDateOfTime(planEndTimeMax);
        } else {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(MapUtils.getString(data, "endTime"));
        }
        return endMonthDate;
    }

    public static MobileComponent buildProjectTitle(PcUiBotTaskData pageData, DigiwinAtmcPanelTask panelTask, ApiRequest apiRequest) {
        if (pageData == null) {
            return TitleBody.createEmpty();
        }
        String overdueDate = Optional.ofNullable(pageData.getOverdueDate()).orElse("");

        String remainTime = Optional.ofNullable(pageData.getRemainTime()).orElse("");
        boolean isOverdue = !overdueDate.isEmpty() && remainTime.isEmpty();
        //显示逾期等标签
        List<Tag> tags = new ArrayList<>();
        Tag timeHintTag =
                isOverdue ? Tag.createWarningTag(localeService.getLanguageValue(apiRequest.getLocale(), "逾期") + overdueDate)
                        : Tag.createPromptTag(localeService.getLanguageValue(apiRequest.getLocale(), "倒计时") + remainTime);
        tags.add(timeHintTag);

        PageDesc pageDesc = new PageDesc();
        pageDesc.setTitle(panelTask.getName());
        // 任务表头问号里面增加显示
        String overduePrefix = LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "已逾期") + "%s";
        if (StringUtils.hasLength(overdueDate)) {
            pageDesc.addContent(0xe66e, String.format(overduePrefix, overdueDate), PageDescContentTypeEnum.ABNORMAL.getValue());
        }
        return TitleBody.create(DateTimeUtil.getMonthDateOfTime(pageData.getTaskEndTime())
                + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "需完成")
                + " " + panelTask.getName(), pageDesc, timeHintTag, tags);
    }

    /**
     * @param pcUiBotModel
     * @param apiRequest
     * @param atdmProxyService
     * @return
     */
    public static MobileComponent buildTabs(UiBotModel pcUiBotModel, ApiRequest apiRequest, DigiwinAtdmProxyService atdmProxyService) {
        Boolean headHasEdit = false;
        CustomTabController customTabController = new CustomTabController();
        customTabController.setSwipeable(true);
        customTabController.setTabAlign(0);

        //找到tab标题
        List<String> contentTargetLayoutTypeList = new ArrayList<>();
        contentTargetLayoutTypeList.add(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        UiBotModel contentUiBotModel = pcUiBotModel.searchPcTargetModel(contentTargetLayoutTypeList, new ArrayList<>(), true);
        List<UiBotQueryButton> queryButtonList = Optional.ofNullable(contentUiBotModel.getLayout().stream().findFirst()
                .orElse(new UiBotLayout()).getQueryButtons()).orElse(new ArrayList<>());
        List<CustomTabControllerItem> items = new ArrayList<>(queryButtonList.size());
        if (!CollectionUtils.isEmpty(queryButtonList)) {
            UiBotAction action = getDefaultAction(pcUiBotModel);
            for (int i = 0; i < queryButtonList.size(); i++) {
                CustomTabControllerItem item = new CustomTabControllerItem();
                item.setFlushType(1);
                item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
                UiBotQueryButton queryButton = queryButtonList.get(i);
                String tabTitle = Optional.ofNullable(queryButton).map(UiBotQueryButton::getQueryTitle).orElse("");
                item.setId(UUIDUtil.getUuid());
                item.setName(tabTitle);
                item.setLayoutType(1);
                item.setScrollable(true);
                CustomTabContentArea contentArea = new CustomTabContentArea();
                if (i == 0) {
                    //塞入内容
                    List<CustomTabContentContainer> bodyArea = contentArea.getBodyArea();
                    List<UiBotLayout> layouts = pcUiBotModel.getLayout();
                    Boolean isContent = false;
                    for (int j = 0; j < layouts.size(); j++) {
                        if (isContent) {
                            //如果是FORM_LIST，还需要判断里面有没有ATHEAN_TABLE
                            UiBotLayout uiBotLayout = layouts.get(j);
                            CustomTabContentContainer container = new CustomTabContentContainer();
                            //目前都考虑使用CustomGroup来装
                            container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                            if (PcLayoutEnum.FORM_LIST.getValue().equals(uiBotLayout.getType())) {
                                UiBotLayout tableLayout = getAthenaTableByFormList(uiBotLayout);
                                headHasEdit = ModuleUtils.uibotFormListLayoutHasEdit(uiBotLayout);
                                Map<String, Object> bizData = (Map<String, Object>) pcUiBotModel.getPageData().get(uiBotLayout.getSchema());
                                container.setData(buildFormList(uiBotLayout, bizData,
                                        pcUiBotModel.getExecuteContext(), apiRequest.getLocale(), "",
                                        pcUiBotModel.getRules(), headHasEdit, true, true, apiRequest.getIamUserToken()));
                                bodyArea.add(container);
                                bodyArea.add(addEmptyContainer());
                                if (headHasEdit) {
                                    tableLayout = getAthenaTable(layouts);
                                    if (tableLayout != null) {
                                        List table = buildAthenaTable(pcUiBotModel, tableLayout, apiRequest.getLocale(), action);
                                        contentArea.setSize(Optional.ofNullable(table).map(List::size).orElse(0));
                                    } else {
                                        contentArea.setSize(0);
                                    }
                                    List<CustomTabContentContainer> bottomArea = contentArea.getBottomArea();
                                    BottomButtonList buttonList = new BottomButtonList();
                                    CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
                                    buttonContainer.setPosition(2);
                                    buttonContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                                    Map<String, Object> rawData = new HashMap<>(5);
                                    rawData.put("dataId", apiRequest.getDataId());
                                    rawData.put("tmTaskId", apiRequest.getExtraParameter().getTmTaskId());
                                    rawData.put("tmActivityId", apiRequest.getExtraParameter().getTmActivityId());
                                    rawData.put("rawData", apiRequest.getRawData());
                                    rawData.put("isTabs", true);
                                    buttonList.add(BottomButtonDigiwinAthena.createNextStepButton(apiRequest.getLocale(), rawData));
                                    buttonContainer.setData(buttonList);
                                    bottomArea.add(buttonContainer);
                                    item.setContentArea(contentArea);
                                    item.setAsyncForData(false);
                                    break;
                                } else {
                                    if (tableLayout != null) {
                                        List table = buildAthenaTable(pcUiBotModel, tableLayout, apiRequest.getLocale(), action);
                                        contentArea.setSize(Optional.ofNullable(table).map(List::size).orElse(0));
                                        bodyArea.addAll(table);
                                    }
                                }
                                //如果是ATHENA_TABLE则需要分为很多个customgroup放进去
                            } else if (PcLayoutEnum.ATHENA_TABLE.getValue().equals(uiBotLayout.getType())) {
                                List table = buildAthenaTable(pcUiBotModel, uiBotLayout, apiRequest.getLocale(), action);
                                int size = Optional.ofNullable(table).map(List::size).orElse(0);
                                contentArea.setSize(size);
                                if (size == 0) {
                                    table.add(CustomTabContentContainer.emptyContainer(apiRequest.getLocale()));
                                }
                                bodyArea.addAll(table);
                            } else {
                                //TODO 遇到其他PC端的layout类型后，需要再填充
                            }

                        }
                        if (PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equals(layouts.get(j).getType())) {
                            isContent = true;
                        }
                    }
                    if (CollectionUtils.isEmpty(bodyArea)) {
                        bodyArea.add(CustomTabContentContainer.emptyContainer(apiRequest.getLocale()));
                    }
                    if (!headHasEdit) {
                        BottomButtonList buttonList = (BottomButtonList) ModuleUtils.buildBottomButtonList(pcUiBotModel, ActionTypeEnum.CALL_API_LIST.getValue());
                        if (!CollectionUtils.isEmpty(buttonList)) {
                            //底部按钮
                            List<CustomTabContentContainer> bottomArea = contentArea.getBottomArea();
                            CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
                            buttonContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                            buttonContainer.setPosition(2);
                            buttonContainer.setData(buttonList);
                            bottomArea.add(buttonContainer);

                        }
                    }
                    item.setContentArea(contentArea);
                    item.setAsyncForData(false);
                } else {
                    Map<String, Object> params = JsonUtil.objectToJavaObject(queryButton, Map.class);
                    params.put("executeContext", pcUiBotModel.getExecuteContext());

                    contentArea.setSize(atdmProxyService.getDataSize(apiRequest.getLocale(),
                            apiRequest.getIamUserToken(), params, apiRequest.getTenantId()));
                    item.setContentArea(contentArea);
                }
                Map<String, Object> data = new HashMap<>(1);
                Map<String, Object> rawData = JsonUtil.objectToJavaObject(queryButton, Map.class);
                rawData.put("executeContext", pcUiBotModel.getExecuteContext());
                data.put("rawData", rawData);

                //塞入异步请求配置
                item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create(apiRequest.getIamUserToken(),
                        apiRequest.getLocale(), apiRequest.getRequestId(),
                        AppContext.getBaseUrl() + "/mobile/v1/uibot/universalparse/component/customtabitem",
                        apiRequest.getClientId(), apiRequest.getTenantId(), data));
                item.setAsyncForData(true);
                items.add(item);
            }
        } else {
            //一个tab签都没有，展示空组件
            return null;
        }

        customTabController.setTabLayoutType(CustomTabControllerItemLayoutTypeEnum.HORIZONTAL.getValue());
        customTabController.setTabItems(items);
        return customTabController;
    }

    /**
     * 只构建第一个tab下的内容
     *
     * @param pcUiBotModel
     * @param apiRequest
     * @return
     */
    public static MobileComponent buildOneTab(UiBotModel pcUiBotModel, ApiRequest apiRequest) {
        CustomTabController customTabController = new CustomTabController();
        customTabController.setSwipeable(true);
        customTabController.setTabAlign(0);

        //找到tab标题
        List<String> contentTargetLayoutTypeList = new ArrayList<>();
        contentTargetLayoutTypeList.add(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        UiBotModel contentUiBotModel = pcUiBotModel.searchPcTargetModel(contentTargetLayoutTypeList, new ArrayList<>(), true);
        List<UiBotQueryButton> queryButtonList = Optional.ofNullable(contentUiBotModel.getLayout().stream().findFirst()
                .orElse(new UiBotLayout()).getQueryButtons()).orElse(new ArrayList<UiBotQueryButton>());
        List<CustomTabControllerItem> items = new ArrayList<>(queryButtonList.size());
        if (queryButtonList.size() > 0) {
            UiBotAction action = getDefaultAction(pcUiBotModel);
            CustomTabControllerItem item = new CustomTabControllerItem();
            item.setFlushType(1);
            item.setContentUseSchema(CustomTabControllerItemContentEnum.CONTENT_AREA.getValue());
            UiBotQueryButton queryButton = queryButtonList.get(0);
            String tabTitle = queryButton.getQueryTitle();
            item.setShowTitle(false);
            item.setId(UUIDUtil.getUuid());
            item.setName(tabTitle == null ? "" : tabTitle);
            item.setLayoutType(1);
            item.setScrollable(true);
            CustomTabContentArea contentArea = new CustomTabContentArea();
            //塞入内容
            List<CustomTabContentContainer> bodyArea = contentArea.getBodyArea();
            List<UiBotLayout> layouts = pcUiBotModel.getLayout();
            Boolean isContent = false;
            for (int j = 0; j < layouts.size(); j++) {
                if (isContent) {
                    //如果是FORM_LIST，还需要判断里面有没有ATHEAN_TABLE
                    UiBotLayout uiBotLayout = layouts.get(j);
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    //目前都考虑使用CustomGroup来装
                    container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                    if (PcLayoutEnum.FORM_LIST.getValue().equals(uiBotLayout.getType())) {
                        UiBotLayout tableLayout = getAthenaTableByFormList(uiBotLayout);
                        if (tableLayout != null) {
                            List table = buildAthenaTable(pcUiBotModel, tableLayout, apiRequest.getLocale(), action);
                            bodyArea.addAll(table);
                            break;
                        }

                        //如果是ATHENA_TABLE则需要分为很多个customgroup放进去
                    } else if (PcLayoutEnum.ATHENA_TABLE.getValue().equals(uiBotLayout.getType())) {
                        List table = buildAthenaTable(pcUiBotModel, uiBotLayout, apiRequest.getLocale(), action);
                        contentArea.setSize(table != null ? table.size() : 0);
                        bodyArea.addAll(table);
                    } else {
                        //TODO 遇到其他的在填充
                    }

                }
                if (PcModuleEnum.CONTENT_QUERY_BUTTON.getValue().equals(layouts.get(j).getType())) {
                    isContent = true;
                }
            }

            BottomButtonList buttonList = (BottomButtonList) ModuleUtils.buildBottomButtonList(pcUiBotModel, ActionTypeEnum.CALL_API_BACK_TWO.getValue());
            if (buttonList != null && buttonList.size() > 0) {
                //底部按钮
                List<CustomTabContentContainer> bottomArea = contentArea.getBottomArea();
                CustomTabContentContainer buttonContainer = new CustomTabContentContainer();
                buttonContainer.setContentCmptType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                buttonContainer.setPosition(2);
                buttonContainer.setData(buttonList);
                bottomArea.add(buttonContainer);
                item.setContentArea(contentArea);
                item.setAsyncForData(false);
            }


            Map<String, Object> data = new HashMap<>(1);
            Map<String, Object> rawData = JsonUtil.objectToJavaObject(queryButton, Map.class);
            rawData.put("executeContext", pcUiBotModel.getExecuteContext());
            data.put("rawData", rawData);

            //塞入异步请求配置
            item.setAsyncConfig(CustomTabControllerItemAsyncConfig.create(apiRequest.getIamUserToken(),
                    apiRequest.getLocale(), apiRequest.getRequestId(),
                    AppContext.getBaseUrl() + "/mobile/v1/uibot/universalparse/component/customtabitem",
                    apiRequest.getClientId(), apiRequest.getTenantId(), data));
            item.setAsyncForData(true);
            items.add(item);

        } else {
            //一个tab签都没有，展示空组件
            return null;
        }

        customTabController.setTabLayoutType(0);
        customTabController.setTabItems(items);
        return customTabController;
    }

    public static UiBotLayout getAthenaTable(List<UiBotLayout> layouts) {
        for (UiBotLayout layout : layouts) {
            if (PcLayoutEnum.ATHENA_TABLE.getValue().equalsIgnoreCase(layout.getType())) {
                return layout;
            }
        }
        return null;
    }

    /**
     * 从PC最外层是FORM_LIST的布局中，找到ATHENA_TABLE布局
     *
     * @param uiBotLayout PC的uibot布局对象
     * @return
     */
    public static UiBotLayout getAthenaTableByFormList(UiBotLayout uiBotLayout) {
        String schema = uiBotLayout.getSchema();
        for (UiBotLayout layout : uiBotLayout.getGroup()) {
            if (PcLayoutEnum.FORM_LIST.getValue().equalsIgnoreCase(layout.getType())) {
                UiBotLayout botLayout = getAthenaTableByFormList(layout);
                if (botLayout != null && PcLayoutEnum.ATHENA_TABLE.getValue().equalsIgnoreCase(botLayout.getType())) {
                    botLayout.setSchema(schema + "." + botLayout.getSchema());
                    return botLayout;
                }
            }
            if (PcLayoutEnum.ATHENA_TABLE.getValue().equalsIgnoreCase(layout.getType())) {
                return layout;
            }
        }
        return null;
    }

    /**
     * 判断是否支持批量提交
     *
     * @param pcUiBotModel
     * @return
     */
    public static UiBotAction getDefaultAction(UiBotModel pcUiBotModel) {
        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return null;
        }
        // 获得实际业务的数据对象
        for (UiBotAction action : uiBotActions) {
            if (action.getDefaultAction()) {
                return action;
            }

        }
        return null;
    }

    /**
     * 构建table条目
     *
     * @param pcUiBotModel
     * @param tableLayout
     * @param locale
     * @param action
     * @return
     */
    public static List<CustomTabContentContainer> buildAthenaTable(UiBotModel pcUiBotModel, UiBotLayout tableLayout,
                                                                   String locale, UiBotAction action) {
        List<UiBotRule> rules = pcUiBotModel.getRules();
        UiBotPageData pageData = pcUiBotModel.getPageData();
        List<CustomTabContentContainer> contentContainers = new ArrayList<>();
        String schema = tableLayout.getSchema();
        List<Map<String, Object>> tablePageDatas = new ArrayList<>();
        //拿到table的pageData
        if (schema.contains(".")) {
            String[] schemas = schema.split("\\.");
            Map<String, Object> map = new HashMap<>();
            for (String tableSchema : schemas) {
                if (map.get(tableSchema) instanceof List) {
                    tablePageDatas = JsonUtil.objectToJavaObject(map.get(tableSchema), List.class);
                } else if (map.get(tableSchema) instanceof Map) {
                    map = (Map<String, Object>) map.get(tableSchema);
                } else {
                    if (pageData.get(tableSchema) instanceof Map) {
                        map = (Map<String, Object>) pageData.get(tableSchema);
                    }
                }

            }
        } else {
            tablePageDatas = JsonUtil.objectToJavaObject(pageData.get(schema), List.class);
        }
        List<UiBotTableColumnDefinition> columnDefs = tableLayout.getColumnDefs();
        int showFiledCount = 1;
        boolean hasEditable = false;
        Map<String, MobileColumn> columnSchemaMap = new LinkedHashMap<>(4);
        //判断是不是有编辑的字段
        for (UiBotTableColumnDefinition definition : columnDefs) {
            List<UiBotTableColumn> tableColumns = definition.getColumns();
            for (UiBotTableColumn tableColumn : tableColumns) {
                if (tableColumn.canEdit()) {
                    hasEditable = true;
                    break;
                }
            }
            if (hasEditable) {
                break;
            }
        }
        //TODO 之前有拆分字段的方法,后面可优化
        for (UiBotTableColumnDefinition definition : columnDefs) {
            List<UiBotTableColumn> tableColumns = definition.getColumns();
            for (UiBotTableColumn tableColumn : tableColumns) {
                if (!tableColumn.canEdit()) {
                    if (showFiledCount > ONLY_READ_FILED_SIZE) {
                        break;
                    }
                    if (PcModuleEnum.LABEL.getValue().equals(tableColumn.getType())
                            || PcModuleEnum.OPERATION_EDITOR.getValue().equals(tableColumn.getType())
                            || PcModuleEnum.AMOUNT_INPUT.getValue().equals(tableColumn.getType())
                            || PcModuleEnum.INPUT.getValue().equals(tableColumn.getType())
                    ) {
                        columnSchemaMap.put(tableColumn.getSchema(), new MobileColumn(Field.COMPONENT_TYPE, tableColumn.getHeaderName(), tableColumn));
                    } else if (PcModuleEnum.NAME_CODE_COMPONENT.getValue().equals(tableColumn.getType())) {
                        //名字编码容器
                        List<UiBotTableColumn> columnColumns = tableColumn.getColumns();
                        for (UiBotTableColumn column : columnColumns) {
                            if (!column.canEdit()) {
                                if (PcModuleEnum.LABEL.getValue().equals(column.getType())) {
                                    columnSchemaMap.put(column.getSchema(), new MobileColumn(Field.COMPONENT_TYPE, column.getHeaderName(), tableColumn));
                                    showFiledCount++;
                                }
                            }
                        }
                        showFiledCount--;
                    } else if (PcModuleEnum.TEXTAREA.getValue().equals(tableColumn.getType()) ||
                            PcModuleEnum.TEXTAREA_TEXT.getValue().equals(tableColumn.getType())) {
                        // TODO table转换成列表时，展示均使用只读的Field字段。先完成工作坊的需求，再来讨论这样改是否正确
                        columnSchemaMap.put(tableColumn.getSchema(), new MobileColumn(InputMultiText.COMPONENT_TYPE, tableColumn.getHeaderName(), tableColumn));
                    } else if (PcModuleEnum.DYNAMIC_GRAPH_VIEWER.getValue().equals(tableColumn.getType())) {
                        //TODO 图档预览暂时无适合组件，先转换为FILED组件
                        columnSchemaMap.put(tableColumn.getSchema(), new MobileColumn(Field.COMPONENT_TYPE, tableColumn.getHeaderName(), tableColumn));
                    } else if (PcModuleEnum.DATEPICKER.getValue().equals(tableColumn.getType())) {
                        columnSchemaMap.put(tableColumn.getSchema(), new MobileColumn(InputDateTimePicker.COMPONENT_TYPE, tableColumn.getHeaderName(), tableColumn));
                    } else if (PcModuleEnum.CHECKBOX.getValue().equals(tableColumn.getType())) {
                        columnSchemaMap.put(tableColumn.getSchema(), new MobileColumn(InputSwitch.COMPONENT_TYPE, tableColumn.getHeaderName(), tableColumn));
                    } else if (PcModuleEnum.FILE_UPLOAD.getValue().equals(tableColumn.getType())) {
                        showFiledCount--;
                    }
                    showFiledCount++;
                }
                if (showFiledCount > ONLY_READ_FILED_SIZE) {
                    break;
                }
            }
        }
        if (!CollectionUtils.isEmpty(columnSchemaMap) && !CollectionUtils.isEmpty(tablePageDatas)) {
            LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

            for (Map<String, Object> tablePageData : tablePageDatas) {
                CustomTabContentContainer container = new CustomTabContentContainer();
                CustomGroup customGroup = new CustomGroup();
                customGroup.setHasEditable(false);
                CustomGroupContent customGroupContent = new CustomGroupContent();
                List<UiBotLayout> customLayout = new ArrayList<>(3);
                UiBotPageData customPageData = new UiBotPageData();
                Integer titleFild = 0;
                for (String columSchema : columnSchemaMap.keySet()) {
                    MobileColumn mobileColumn = columnSchemaMap.get(columSchema);
                    String possiblePlaceholder = localeService.getLanguageValue(locale, "请输入") + mobileColumn.getHeaderName();

                    Object bizData = tablePageData.get(columSchema);
                    UiBotLayout layout = new UiBotLayout();
                    layout.setSchema(columSchema);
                    layout.setType(mobileColumn.getType());
                    switch (mobileColumn.getType()) {
                        case Field.COMPONENT_TYPE:
                            if (titleFild == 0) {
                                customPageData.put(columSchema, Field.create("", mobileColumn.getTableColumn().getValueForDisplay(tablePageData),
                                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue(),
                                        FieldValueStyleTypeEnum.VALUE_BIG_TITLE.getValue(), false));
                                titleFild++;
                            } else {
                                customPageData.put(columSchema, Field.createLabelValueLeftFieldNoNewLineWith18px(mobileColumn.getHeaderName(),
                                        bizData != null ? String.valueOf(bizData) : ""));
                            }
                            customLayout.add(layout);
                            break;
                        case InputMultiText.COMPONENT_TYPE:
                            customPageData.put(columSchema, InputMultiText.create(
                                    mobileColumn.getHeaderName(), (String) bizData, false, false, locale, possiblePlaceholder));
                            customLayout.add(layout);
                            break;
                        case InputDateTimePicker.COMPONENT_TYPE:
                            customPageData.put(columSchema, InputDateTimePicker.create(columSchema,
                                    mobileColumn.getHeaderName(), bizData, locale,
                                    InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType()));
                            customLayout.add(layout);
                            break;
                        case InputSwitch.COMPONENT_TYPE:
                            customPageData.put(columSchema, InputSwitch.create((Boolean) bizData, mobileColumn.getHeaderName()));
                            customLayout.add(layout);
                            break;
                        default:
                            break;
                    }
                }
                //如果有编辑字段，需加个编辑按钮
                if (hasEditable) {
                    UiBotLayout buttonLayOut = new UiBotLayout();
                    BottomButtonList buttonList = new BottomButtonList();
                    buttonLayOut.setType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                    BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
                    button.setAction(buildAction(tableLayout, pageData, tablePageData, action, hasEditable, rules, pcUiBotModel.getExecuteContext()));
                    button.setName(LocaleUtil.getMobileTextByKey(locale, "去处理"));
                    button.setStateName(LocaleUtil.getMobileTextByKey(locale, "已处理"));
                    button.setType(BottomButtonStyleEnum.DETAIL_NORMAL.getValue());
                    buttonList.add(button);
                    buttonLayOut.setSchema("edit");
                    customPageData.put("edit", buttonList);
                    customLayout.add(buttonLayOut);
                    customGroup.setSizeType(SizeTypeEnum.TWO.getValue());
                    customGroup.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                } else {
                    customGroup.setSizeType(SizeTypeEnum.ZERO.getValue());
                }
                //为了方便前端滑动，故customGroup也都给Action
                customGroup.setAction(buildAction(tableLayout, pageData, tablePageData, action, hasEditable, rules, pcUiBotModel.getExecuteContext()));
                customGroupContent.setLayout(customLayout);
                customGroupContent.setPageData(customPageData);
                customGroup.setContent(customGroupContent);
                customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY.getValue());
                customGroup.setUseExpand(false);
                customGroup.setHasDetail(true);
                customGroup.setName("");
                customGroup.setHiddenConfig(new HiddenConfig());
                container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                container.setData(customGroup);
                contentContainers.add(container);
            }
        }


        return contentContainers;
    }

    /**
     * 将FORM_LIST组件转换为移动组件
     *
     * @param uiBotLayout
     * @param bizData
     * @param executeContext
     * @param locale
     * @param useDefault     是否在字段值为空时，展示默认的中线符号
     * @param iamUserToken
     * @return
     */
    public static MobileComponent buildFormList(UiBotLayout uiBotLayout, Map<String, Object> bizData,
                                                UiBotExecuteContext executeContext, String locale,
                                                String customName, List<UiBotRule> rules, Boolean headHasEdit, Boolean isRoot, boolean useDefault, String iamUserToken) {
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(customName);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_INPUT_FORM.getValue());
        List<UiBotLayout> group = uiBotLayout.getGroup();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        List<UiBotLayout> customLayout = new ArrayList<>(group.size());
        UiBotPageData pageData = new UiBotPageData();
        Integer fieldType = FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_WITH_18PX.getValue();
        if (headHasEdit) {
            fieldType = FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX.getValue();
        }

        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

        Boolean hasEditable = false;
        //判断是否有图片组件
        Boolean hasPic = false;
        for (UiBotLayout groupLayout : group) {
            UiBotLayout layout = new UiBotLayout();
            String schema = groupLayout.getSchema();
            if (StringUtils.hasLength(schema)) {
                layout.setSchema(schema);
            }
            String data = layout.getValueForDisplay(bizData);
            // 只读字段在默认情况下，没有值时，展示"-"符号
            if (useDefault && !StringUtils.hasLength(data) && !groupLayout.canEdit()) {
                data = "-";
            }
            String possiblePlaceholder = groupLayout.getPlaceholder();
            if (!StringUtils.hasLength(possiblePlaceholder)) {
                possiblePlaceholder = localeService.getLanguageValue(locale, "请输入");
                if (StringUtils.hasLength(groupLayout.getHeaderName())) {
                    possiblePlaceholder += groupLayout.getHeaderName().trim();
                } else {
                    possiblePlaceholder += groupLayout.getLabel() == null ? "" : groupLayout.getLabel().trim();
                }
            }
            BaseInputMobileComponent inputMobileComponent;
            //单行文本
            if (PcModuleEnum.INPUT.getValue().equals(groupLayout.getType())
                    || PcModuleEnum.LABEL.getValue().equals(groupLayout.getType())
                    || PcModuleEnum.CUST_FRC_GENERAL_WINDOW_STANDARD.getValue().equals(groupLayout.getType())
                    || PcModuleEnum.CUST_FRC_DEVICE_NAME.getValue().equals(groupLayout.getType())
            ) {
                // 用INPUT_SINGLE组件
                inputMobileComponent = InputSingleText.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
                        data, locale, schema, rules, groupLayout.canEdit());
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    // 可编辑
                    hasEditable = true;
//                    layout.setType(InputSingleText.COMPONENT_TYPE);
//                    pageData.put(schema, InputSingleText.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            data, locale, schema, rules, groupLayout.getEditable()));
                    inputMobileComponent.setEnable(true);
                } else {
                    // 不可编辑
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
                //TODO 目前PC端是支持输入的开窗单选
            } else if (PcModuleEnum.CONTACT.getValue().equals(groupLayout.getType())
                    || PcModuleEnum.ADDRESS.getValue().equals(groupLayout.getType())) {
                inputMobileComponent = InputSingleText.create(groupLayout.getLabel(),
                        data, locale, schema, rules, groupLayout.canEdit());
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    //可编辑用INPUT_SINGLE组件
                    hasEditable = true;
//                    layout.setType(InputSingleText.COMPONENT_TYPE);
//                    pageData.put(schema, InputSingleText.create(groupLayout.getLabel(),
//                            data, locale, schema, rules, groupLayout.canEdit()));
                    inputMobileComponent.setEnable(true);
                } else {
                    //不可编辑用FIELD组件
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getLabel(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.OPERATION_EDITOR.getValue().equals(groupLayout.getType())) {
                inputMobileComponent = InputWindowSingleSelect.create(groupLayout, false,
                        AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                        locale, executeContext, groupLayout.canEdit(), bizData, schema, rules);
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputWindowSingleSelect.COMPONENT_TYPE);
//                    pageData.put(schema, InputWindowSingleSelect.create(groupLayout, false,
//                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
//                            locale, executeContext, groupLayout.canEdit(), bizData, schema, rules));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.FORM_OPERATION_EDITOR.getValue().equals(groupLayout.getType())) {
                // 开窗选择。FIXME 是否多选需改造，读取组件的配置。若有设计器，则读设计器；若无则读取pc，和它保持一致
                inputMobileComponent = InputWindowMultiSelect.create(groupLayout, null, (List<Map<String, Object>>) bizData.get(schema),
                        AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list", locale, executeContext);
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputWindowMultiSelect.COMPONENT_TYPE);
//                    pageData.put(schema, InputWindowMultiSelect.create(groupLayout, null, (List<Map<String, Object>>) bizData.get(schema),
//                            AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list", locale, executeContext));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.TEXTAREA.getValue().equals(groupLayout.getType())) {
                inputMobileComponent = InputMultiText.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
                        data, groupLayout.canEdit(), false, locale, possiblePlaceholder);
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                // 多行文本
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputMultiText.COMPONENT_TYPE);
//                    pageData.put(schema, InputMultiText.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            data, groupLayout.canEdit(), false, locale, possiblePlaceholder));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.SELECT.getValue().equalsIgnoreCase(groupLayout.getType())) {
                inputMobileComponent = SingleSelectList.create(groupLayout, data, false);
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                //弹窗单选
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(SingleSelectList.COMPONENT_TYPE);
//                    pageData.put(schema, SingleSelectList.create(groupLayout, data, false));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.DATEPICKER.getValue().equals(groupLayout.getType())) {
                // FIXME 生成组件用的schema有问题，要优化
                inputMobileComponent = InputDateTimePicker.create(schema,
                        groupLayout.getPlaceholder(), bizData.get(schema), locale,
                        InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(),
                        "feedback_start_date", "feedback_end_date");
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                //时间选择器组件
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputDateTimePicker.COMPONENT_TYPE);
//                    pageData.put(schema, InputDateTimePicker.create(schema,
//                            groupLayout.getPlaceholder(), bizData.get(schema), locale,
//                            InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(), "feedback_start_date", "feedback_end_date"));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.EOC_SELECT.getValue().equals(groupLayout.getType())) {
                List<String> schemas = groupLayout.getSchemas();
                String secondSchema = "";
                for (String s : schemas) {
                    if (!s.equals(schema)) {
                        secondSchema = s;
                    }
                }
                //公司别
                List<Map<String, Object>> companys = (List<Map<String, Object>>) bizData.get("companys");
                //工厂别
                List<Map<String, Object>> factorys = (List<Map<String, Object>>) bizData.get("factorys");
                String title = StringUtils.hasLength(groupLayout.getHeaderName()) ? groupLayout.getHeaderName() : groupLayout.getPlaceholder();

                inputMobileComponent = InputCascade.create(companys, factorys, schema, secondSchema,
                        title, 2, InputCascadeTypeEnum.PARSE.getValue(),
                        InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), locale);
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputCascade.COMPONENT_TYPE);
//                    List<String> schemas = groupLayout.getSchemas();
//                    String secondSchema = "";
//                    for (String s : schemas) {
//                        if (!s.equals(schema)) {
//                            secondSchema = s;
//                        }
//                    }
//                    //公司别
//                    List<Map<String, Object>> companys = (List<Map<String, Object>>) bizData.get("companys");
//                    //工厂别
//                    List<Map<String, Object>> factorys = (List<Map<String, Object>>) bizData.get("factorys");
//                    String title = StringUtils.hasLength(groupLayout.getHeaderName()) ? groupLayout.getHeaderName() : groupLayout.getPlaceholder();
//                    pageData.put(schema, InputCascade.create(companys, factorys, schema, secondSchema,
//                            title, 2, InputCascadeTypeEnum.PARSE.getValue(),
//                            InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), locale));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcModuleEnum.DATE_RANGE.getValue().equals(groupLayout.getType())) {
                List<String> datas = new ArrayList<>();
                if (bizData.get(schema) instanceof List) {
                    datas = (List<String>) bizData.get(schema);
                }

                inputMobileComponent = InputCalendar.create(groupLayout, datas, InputCalendarTypeEnum.SELECT_DATE_RANGE.getValue());
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    hasEditable = true;
//                    layout.setType(InputCalendar.COMPONENT_TYPE);
//                    List<String> datas = new ArrayList<>();
//                    if (bizData.get(schema) instanceof List) {
//                        datas = (List<String>) bizData.get(schema);
//                    }
//                    pageData.put(schema, InputCalendar.create(groupLayout, datas, InputCalendarTypeEnum.SELECT_DATE_RANGE.getValue()));
                    inputMobileComponent.setEnable(true);
                } else {
//                    layout.setType(Field.COMPONENT_TYPE);
//                    pageData.put(schema, Field.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
//                            groupLayout.getType(), data, schema, fieldType));
                    inputMobileComponent.setEnable(false);
                }
            } else if (PcLayoutEnum.ATHENA_TABLE.getValue().equals(groupLayout.getType())) {

            } else if (PcLayoutEnum.FORM_LIST.getValue().equals(groupLayout.getType())) {
                layout.setType(CustomGroup.COMPONENT_TYPE);
                if (schema == null) {
                    schema = UUIDUtil.getUuid();
                    layout.setSchema(schema);
                }
                pageData.put(schema, buildFormList(groupLayout, bizData, executeContext, locale,
                        customName, rules, headHasEdit, false, useDefault, iamUserToken));
//            } else if () { // TODO dataType=numeric数值类型的字段的组件生成

            } else {
                inputMobileComponent = InputSingleText.create(groupLayout.getHeaderName() == null ? groupLayout.getPlaceholder() : groupLayout.getHeaderName(),
                        data, locale, schema, rules, groupLayout.canEdit());
                layout.setType(inputMobileComponent.returnComponentType());
                pageData.put(schema, inputMobileComponent);
                if (groupLayout.canEdit()) {
                    inputMobileComponent.setEnable(true);
                } else {
                    inputMobileComponent.setEnable(false);
                }
            }
            customLayout.add(layout);
        }

        //字段的收起展开
        if (group.size() > FILED_MORE_SIZE) {
            customGroup.setUseExpand(true);
            HiddenConfig hiddenConfig = new HiddenConfig();
            hiddenConfig.setHiddenType(HiddenConfigTypeEnum.FIELD.getValue());
            hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(locale, "查看更多"));
            hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(locale, "收起"));
            hiddenConfig.setHiddenCount(FILED_MORE_SIZE);
            customGroup.setHiddenConfig(hiddenConfig);
        } else {
            customGroup.setUseExpand(false);
        }

        //CustomGroup展示方式 TODO 未来有图片可能再扩展
        if (Boolean.FALSE.equals(hasPic)) {
            customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING_BOTTOM.getValue());
        }
        if (!headHasEdit && Boolean.TRUE.equals(isRoot)) {
            customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING.getValue());
        }
        customGroup.setHasEditable(hasEditable);
        customGroupContent.setLayout(customLayout);
        customGroupContent.setPageData(pageData);
        customGroup.setContent(customGroupContent);
        return customGroup;
    }


    /**
     * PC的底部按钮转换为底部按钮
     *
     * @param pcUiBotModel
     * @return
     */
    public static MobileComponent buildBottomButtonList(UiBotModel pcUiBotModel, int actionType) {
        BottomButtonList buttonList = new BottomButtonList();
        List<UiBotAction> uiBotActions = pcUiBotModel.getActions();
        if (null == uiBotActions || uiBotActions.isEmpty()) {
            return BottomButtonList.createEmpty();
        }

        if (uiBotActions.size() > BUTTON_MORE_SIZE) {
            for (int i = 0; i < uiBotActions.size(); i++) {
                UiBotAction action = uiBotActions.get(i);
                UiBotActionSubmitType submitType = action.getSubmitType();
                Object bizData = pcUiBotModel.getPageData().get(submitType.getSchema());
                if (isEmptyData(bizData)) {
                    return BottomButtonList.createEmpty();
                }
                //默认的按钮（提交）位于最右边，即第三位
                if (action.getDefaultAction()) {
                    if (!action.getSubmitType().getIsBatch()) {
                        buttonList.add(BUTTON_MORE_SIZE - 1, BottomButtonDigiwinAthena.create(action,
                                buildButtonRawData(action, submitType.getSchema(), bizData), true, actionType));
                    } else {
                        break;
                    }
                } else {
                    //倒数第二位的，位于右边的倒数第二位
                    if (i == uiBotActions.size() - 1) {
                        buttonList.add(BottomButtonDigiwinAthena.create(action,
                                buildButtonRawData(action, submitType.getSchema(), bizData), true, actionType));
                    } else {
                        //其他都收入到...中
                        if (buttonList.size() < BUTTON_MORE_SIZE) {
                            BottomButtonDigiwinAthena bottomButton = BottomButtonDigiwinAthena.create(
                                    BottomButtonStyleEnum.NORMAL.getValue(), "...");
                            List<BottomButtonDigiwinAthena> bottomButtonChildrens = bottomButton.getChildren();
                            for (int j = 0; j < uiBotActions.size() - 2; j++) {
                                bottomButtonChildrens.add(BottomButtonDigiwinAthena.create(action,
                                        buildButtonRawData(action, submitType.getSchema(), bizData), true, actionType));
                            }
                            buttonList.add(bottomButton);
                        }
                    }
                }
            }
        } else {
            // 获得实际业务的数据对象
            for (UiBotAction action : uiBotActions) {
                UiBotActionSubmitType submitType = action.getSubmitType();
                Object bizData = pcUiBotModel.getPageData().get(submitType.getSchema());
                if (Boolean.TRUE.equals(isEmptyData(bizData))) {
                    return BottomButtonList.createEmpty();
                }
                //不支持批量
                if (Boolean.FALSE.equals(submitType.getIsBatch())) {
                    buttonList.add(BottomButtonDigiwinAthena.create(action, buildButtonRawData(action, submitType.getSchema(), bizData), true, actionType));
                }
            }
        }
        return buttonList;
    }


    /**
     * 构造按钮的rawData
     *
     * @param action
     * @param schema
     * @param bizData
     * @return
     */
    private static Map<String, Object> buildButtonRawData(UiBotAction action, String schema, Object bizData) {
        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("action", action);
        Map<String, Object> data = new HashMap<>(1);
        data.put(schema, bizData);
        rawData.put("data", data);
        return rawData;
    }

    /**
     * 判断取得pageData数据是否为空
     *
     * @param bizData
     * @return
     */
    private static Boolean isEmptyData(Object bizData) {
        if (bizData == null) {
            return true;
        } else if (bizData instanceof List) {
            if (((List<?>) bizData).isEmpty()) {
                return true;
            }
        } else if (bizData instanceof Map) {
            if (((Map) bizData).isEmpty()) {
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private static Action buildAction(UiBotLayout tableLayout, UiBotPageData pageData,
                                      Map<String, Object> tablePageData, UiBotAction defaultAction,
                                      Boolean hasEditable, List<UiBotRule> rules, UiBotExecuteContext executeContext) {
        Action action = new Action();
        Map<String, Object> rawData = new HashMap<>(1);
        List<List<ParseFieldData>> fieldDataListList = TableUiBotParser.parseTableUiBotData(tableLayout, pageData);
        Boolean findPageData = false;
        for (List<ParseFieldData> parseFieldDatas : fieldDataListList) {
            for (ParseFieldData parseFieldData : parseFieldDatas) {
                if (parseFieldData.getData() instanceof String &&
                        ((String) parseFieldData.getData()).equalsIgnoreCase(
                                (String) tablePageData.get(parseFieldData.getSchema()))) {
                    findPageData = true;
                    rawData.put("data", parseFieldDatas);
                    rawData.put("isEditable", hasEditable);
                    break;
                } else {
                    break;
                }
            }
            if (findPageData) {
                break;
            }
        }
        action.setRawData(rawData);
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
        action.setType(ActionTypeEnum.OPEN_TABS.getValue());
        return action;
    }

    /**
     * 搜索的倒数第二层组件，包装
     * 结构中第一层的formList是有schema的，后面的都没有，故拿第一层的给到没有的
     *
     * @param tabLayouts
     * @param searchAllLayour
     * @return
     */
    public static List<UiBotLayout> searchAllModule(List<UiBotLayout> tabLayouts, List<UiBotLayout> searchAllLayour) {
        for (UiBotLayout layout : tabLayouts) {
            String type = layout.getType();
            String schema = layout.getSchema();
            //FORM_LIST组件
            if (type.equalsIgnoreCase(PcLayoutEnum.FORM_LIST.getValue())) {
                List<UiBotLayout> layoutGroup = layout.getGroup();
                List<UiBotLayout> list = searchAllModule(layoutGroup, searchAllLayour);
                Boolean hasNext = false;
                for (UiBotLayout lay : list) {
                    if (lay.getType().equals(PcLayoutEnum.FORM_LIST.getValue())) {
                        if (StringUtils.hasLength(schema)) {
                            lay.setSchema(schema);
                        }
                        hasNext = true;
                        break;
                    }
                }
                for (UiBotLayout lay : list) {
                    if (lay.getType().equals(PcLayoutEnum.ATHENA_TABLE.getValue())) {
                        if (StringUtils.hasLength(schema)) {
                            lay.setSchema(schema + "." + lay.getSchema());
                        }
                        break;
                    }
                }
                if (!hasNext) {
                    searchAllLayour.removeAll(list);
                    searchAllLayour.add(layout);
                }
                //ATHENA_TABLE组件
            } else if (type.equalsIgnoreCase(PcLayoutEnum.ATHENA_TABLE.getValue())) {
                searchAllLayour.add(layout);
            } else {
                searchAllLayour.add(layout);
            }

        }
        return searchAllLayour;
    }

    /**
     * 可能存在JavaBean转换异常，建议使用listMapToListT
     *
     * @param listmap
     * @param object
     * @param <T>
     * @return
     */
    @Deprecated
    public static <T> List<T> listMapToListObject(List<?> listmap, Class<T> object) {
        JSONArray array = new JSONArray();
        array.addAll(listmap);
        return array.toJavaList(object);
    }

    public static <T> List<T> listMapToListT(List<Map<String, Object>> listmap, Class<T> object) {
        List<T> paramList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(listmap)) {
            for (Map<String, Object> map : listmap) {
                paramList.add(parseMapObject(map, object));
            }
        }
        return paramList;
    }

    public static <T> T parseMapObject(Map<String, Object> paramMap, Class<T> cls) {
        return JSONObject.parseObject(JSONObject.toJSONString(paramMap), cls);
    }

    public static <T> List<T> listToListObject(List<Map<String, Object>> listmap, Class<T> object) {
        if (!CollectionUtils.isEmpty(listmap)) {
            List<T> list = new ArrayList<>(listmap.size());
            if (listmap.get(0) instanceof Map) {
                for (Map<String, Object> map : listmap) {
                    list.add(JsonUtil.objectToJavaObject(map, object));
                }
            } else if (listmap.get(0) instanceof BottomButtonDigiwinAthena) {
                return (List<T>) listmap;
            } else {
                for (int i = 0; i < listmap.size(); i++) {
                    list.add(JsonUtil.objectToJavaObject(JsonUtil.objectToJavaObject(listmap.get(0), Map.class), object));
                }
            }
            return list;
        } else {
            return Collections.emptyList();
        }
    }


    /**
     * 编辑回复型单头内容(目前取固定字段：description、title)
     *
     * @param pcUiBotModelLayout
     * @param pageData
     * @param apiRequest
     * @return
     */
    public static MobileComponent buildReplyTitle(UiBotLayout pcUiBotModelLayout, Map<String, Object> pageData, ApiRequest apiRequest) {
        CustomGroup customGroup = new CustomGroup();

        //所属公司-工厂
        List<String> eocNames = UiBotModel.getEocNames(JsonUtil.objectToJavaObject(pageData, UiBotPageData.class));
        if (eocNames != null && eocNames.size() > 0) {
            customGroup.setName(eocNames.get(0));
        }
        customGroup.setHasDetail(false);
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> layouts = new ArrayList<>(2);
        UiBotPageData data = new UiBotPageData();
        //取title
        UiBotLayout titleLayout = new UiBotLayout();
        titleLayout.setSchema("title");
        titleLayout.setType(Field.COMPONENT_TYPE);
        layouts.add(titleLayout);
        content.setLayout(layouts);

        //取description
        UiBotLayout layout = new UiBotLayout();
        layout.setSchema("description");
//        layout.setType(InputMultiText.COMPONENT_TYPE);
        layout.setType(TextMulti.COMPONENT_TYPE);
        layouts.add(layout);
        content.setLayout(layouts);


        data.put("title", Field.createLabelValueLeftField("", (String) pageData.get("title")));
//        data.put("description", InputMultiText.create("", (String) pageData.get("description"), false, false, apiRequest.getLocale()));
        data.put("description", TextMulti.create("", (String) pageData.get("description"), apiRequest.getLocale(), 1));
        content.setPageData(data);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.TEXT_ONLY_NO_PADDING_BOTTOM.getValue());
        customGroup.setContent(content);
        return customGroup;
    }

    /**
     * 判断customGroup是否为空
     *
     * @param customGroup
     * @return
     */
    public static Boolean customGroupIsEmpty(CustomGroup customGroup) {
        if (customGroup.getContent() == null) {
            return true;
        } else if (customGroup.getContent().getPageData() == null
                || customGroup.getContent().getPageData().size() == 0) {
            return true;
        }
        return false;
    }

    /**
     * 判断uibot是否不为空
     *
     * @param uiBotModel
     * @return
     */
    public static Boolean uibotIsNotEmpty(UiBotModel uiBotModel) {
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Boolean isHasValue = false;
        if (pageData == null || uiBotLayouts == null) {
            return false;
        }
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            if (pageData.get(uiBotLayout.getSchema()) instanceof List) {
                List<Map<String, Object>> datas = (List<Map<String, Object>>) pageData.get(uiBotLayout.getSchema());
                if (isHasValue(datas)) {
                    isHasValue = true;
                    break;
                }
            } else if (pageData.get(uiBotLayout.getSchema()) instanceof Map) {
                Map<String, Object> data = (Map<String, Object>) pageData.get(uiBotLayout.getSchema());
                if (isHasValue(data.values().stream().distinct().collect(Collectors.toList()))) {
                    isHasValue = true;
                    break;
                }
            } else {
                if (pageData.get(uiBotLayout.getSchema()) != null) {
                    isHasValue = true;
                    break;
                }
            }
        }
        return isHasValue;
    }

    public static Boolean isHasValue(List list) {
        Boolean isHasValue = false;
        for (Object d : list) {
            if (d instanceof String) {
                if (StringUtils.hasLength((String) d)) {
                    isHasValue = true;
                    break;
                }
            } else if (d instanceof List) {
                if (((List) d).size() > 0) {
                    isHasValue = true;
                    break;
                }
            } else if (d instanceof Map) {
                //TODO 需要验证一下去重
                if (isHasValue((List) ((Map) d).values().stream().distinct().collect(Collectors.toList()))) {
                    isHasValue = true;
                    break;
                }
            } else if (d instanceof Integer) {
                if ((Integer) d != 0) {
                    isHasValue = true;
                    break;
                }
            }
        }
        return isHasValue;
    }

    /**
     * 判断FormList类型的是否有可编辑字段
     *
     * @param uiBotLayout
     * @return
     */
    public static Boolean uibotFormListLayoutHasEdit(UiBotLayout uiBotLayout) {
        List<UiBotLayout> group = uiBotLayout.getGroup();
        for (UiBotLayout groupLayout : group) {
            if (PcLayoutEnum.FORM_LIST.getValue().equalsIgnoreCase(groupLayout.getType())) {
                if (uibotFormListLayoutHasEdit(groupLayout)) {
                    return true;
                }
            } else if (PcLayoutEnum.ATHENA_TABLE.getValue().equalsIgnoreCase(groupLayout.getType())) {
                return false;
            } else if (groupLayout.canEdit()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断AthenaTable类型是否有可编辑字段
     *
     * @param pcUiBotModel
     * @return
     */
    public static Boolean uibotAthenaTableLaoutHasEdit(UiBotModel pcUiBotModel) {
        List<String> contentTargetLayoutTypeList = new ArrayList<>();
        contentTargetLayoutTypeList.add(PcModuleEnum.CONTENT_QUERY_BUTTON.getValue());
        UiBotModel contentUiBotModel = pcUiBotModel.searchPcTargetModel(contentTargetLayoutTypeList, new ArrayList<>(), true);
        List<UiBotQueryButton> queryButtonList = Optional.ofNullable(contentUiBotModel.getLayout().stream().findFirst()
                .orElse(new UiBotLayout()).getQueryButtons()).orElse(new ArrayList<UiBotQueryButton>());
        if (queryButtonList.size() > 0) {
            for (int i = 0; i < queryButtonList.size(); i++) {
                if (i == 0) {
                    //塞入内容
                    List<UiBotLayout> layouts = pcUiBotModel.getLayout();
                    for (UiBotLayout uiBotLayout : layouts) {
                        if (PcLayoutEnum.FORM_LIST.getValue().equals(uiBotLayout.getType())) {
                            if (uibotFormListLayoutHasEdit(uiBotLayout)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * 头部增加固定的空白区域
     *
     * @param uiBotLayouts
     * @param pageData
     */
    public static void addEmptyArea(List<UiBotLayout> uiBotLayouts, UiBotPageData pageData) {
        UiBotLayout layout = new UiBotLayout();
        String schema = BLANK_AREA_SCHEMA + "-" + UUIDUtil.getUuid();
        layout.setSchema(schema);
        layout.setType(BlankArea.COMPONENT_TYPE);
        uiBotLayouts.add(layout);
        pageData.put(schema, BlankArea.create(24, 1.0));

    }

    private static CustomTabContentContainer addEmptyContainer() {
        CustomTabContentContainer<BlankArea> container = new CustomTabContentContainer<>();
        container.setContentCmptType(BlankArea.COMPONENT_TYPE);
        container.setData(BlankArea.create(24, 1.0));
        return container;
    }

    public static String emptyString(Object value) {
        if (value != null && value instanceof String) {
            if (StringUtils.hasLength((String) value)) {
                return value.toString();
            } else {
                return "";
            }
        } else {
            return "";
        }

    }

    public static String emptyValueToHyphen(Object value) {
        if (value != null) {
            if (value instanceof String) {
                if (StringUtils.hasLength(((String) value).trim())) {
                    return value.toString();
                } else {
                    return "-";
                }
            } else if (value instanceof Double || value instanceof Float) {
                return String.valueOf(value);
            } else {
                return "-";
            }
        } else {
            return "-";
        }
    }

    public static String dealValue(Object value, String locale, LocaleService localeService) {
        if (value != null) {
            if (value instanceof String) {
                if (StringUtils.hasLength((String) value)) {
                    if (value.toString().equalsIgnoreCase(YES)) {
                        return localeService.getLanguageValue(locale, "是");
                    } else if (value.toString().equalsIgnoreCase(NO)) {
                        return localeService.getLanguageValue(locale, "否");
                    }
                    return value.toString();
                } else {
                    return "-";
                }
            } else if (value instanceof Double || value instanceof Float) {
                // 存在小数位全是0的情况，取整，否则转为正常小数
                Double valueByDouble = Double.valueOf(String.valueOf(value));
                if (valueByDouble % 1.0 == 0) {
                    return String.valueOf(valueByDouble.longValue());
                } else {
                    return new BigDecimal(String.valueOf(value)).toString();
                }
            } else if (value instanceof Integer) {
                return String.valueOf(value);
            } else {
                return "-";
            }
        } else {
            return "-";
        }
    }

    /**
     * 给UibotModel里面带有button按钮的都加上刷新ID
     *
     * @param uiBotModel
     * @param refreshPageId
     * @return
     */
    public static UiBotModel addRefreshPageId(UiBotModel uiBotModel, String refreshPageId) {
        UiBotLayout buttonLayout = UiBotModel.getCustomUibotLayout(uiBotModel.getLayout(),
                BottomButtonDigiwinAthena.COMPONENT_TYPE);
        if (buttonLayout != null) {
            try {
                List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listToListObject(
                        (List<Map<String, Object>>) uiBotModel.getPageData().get(buttonLayout.getSchema()),
                        BottomButtonDigiwinAthena.class);
                buttons.stream().forEach(button -> {
                    addRefreshPageId(button, refreshPageId);
                });
                uiBotModel.getPageData().put(buttonLayout.getSchema(), buttons);
                return uiBotModel;
            } catch (Exception e) {
                e.printStackTrace();
            }
            List<Map<String, Object>> buttonMaps = (List<Map<String, Object>>) uiBotModel.getPageData().get(buttonLayout.getSchema());
            for (Map<String, Object> button : buttonMaps) {
                addRefreshPageId(button, refreshPageId);
            }
            uiBotModel.getPageData().put(buttonLayout.getSchema(), buttonMaps);
        }
        return uiBotModel;
    }

    private static Map<String, Object> addRefreshPageId(Map<String, Object> button, String refreshPageId) {
        Action action = JsonUtil.objectToJavaObject(button.get("action"), Action.class);
        if (action != null) {
            if (StringUtils.hasLength(refreshPageId)) {
                action.setRefreshPageId(refreshPageId);
            } else {
                action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
            }
        }
        button.put("action", action);
        return button;
    }

    public static BottomButtonList addRefreshPageId(BottomButtonList buttonList, String refreshPageId) {
        if (!CollectionUtils.isEmpty(buttonList)) {
            for (BottomButtonDigiwinAthena buttonDigiwinAthena : buttonList) {
                addRefreshPageId(buttonDigiwinAthena, refreshPageId);
            }
        }
        return buttonList;
    }

    public static BottomButtonDigiwinAthena addRefreshPageId(BottomButtonDigiwinAthena button, String refreshPageId) {
        Action action = button.getAction();
        if (action != null) {
            if (StringUtils.hasLength(refreshPageId)) {
                action.setRefreshPageId(refreshPageId);
            } else {
                action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
            }
        }
        return button;
    }

    public static Button addRefreshPageId(Button button, String refreshPageId) {
        Action action = button.getAction();
        if (action != null) {
            if (StringUtils.hasLength(refreshPageId)) {
                action.setRefreshPageId(refreshPageId);
            } else {
                action.setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
            }
        }
        return button;
    }

    /**
     * 找到指定路径下的path
     *
     * @param path
     * @param pageData
     * @return
     */
    public static List<Map<String, Object>> getDataListByPath(String path, UiBotPageData pageData) {
        List<Map<String, Object>> datas = new ArrayList<>(6);
        if (pageData.get(path) instanceof List) {
            datas = (List<Map<String, Object>>) pageData.get(path);
        } else {
            if (path.contains(".")) {
                String[] keys = path.split("\\.");
                Map<String, Object> dataMap = new HashMap<>(1);
                if (pageData.get(keys[0]) instanceof Map) {
                    dataMap = (Map<String, Object>) pageData.get(keys[0]);
                }
                for (int i = 1; i < keys.length - 1; i++) {
                    if (dataMap.get(keys[i]) instanceof Map) {
                        dataMap = (Map<String, Object>) dataMap.get(keys[i]);
                    } else if (dataMap.get(keys[i]) instanceof List) {
                        datas = (List<Map<String, Object>>) dataMap.get(keys[i]);
                    }
                }
            } else {
                return datas;
            }
        }
        return datas;
    }
}