package com.digiwin.mobile.mobileuibot.core.layout.generator;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：${请输入当前策略工厂的用途}</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LayoutGeneratorFactory
 * @Author: zaregoto
 * @Date: 2023/3/23 14:40
 */
@Slf4j
@Component("LayoutGeneratorFactory")
public class LayoutGeneratorFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, LayoutGenerator> MAP = new HashMap<>();

    private ApplicationContext appContext;

    public LayoutGenerator get(String key) {
        return MAP.get(key);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 LayoutGenerator 注册到 MAP
        this.appContext.getBeansOfType(LayoutGenerator.class).values().forEach(
                strategy -> MAP.put(strategy.getType(), strategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        this.appContext = applicationContext;
    }
}