package com.digiwin.mobile.mobileuibot.core.layout.generator;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：多层布局生成器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MultiPatternLayoutGenerator
 * @Author: zaregoto
 * @Date: 2023/4/12 20:51
 */
@Slf4j
@Component("multiPatternLayoutGenerator")
public class MultiPatternLayoutGenerator implements LayoutGenerator {

    @Override
    public String getType() {
        return MobileLayoutTypeEnum.MULTI_PATTERN_LAYOUT.getValue();
    }

    @Override
    public BaseLayoutMobileComponent generate(LayoutGeneratorPreprocessData preprocessData) {
        // FIXME 需要返回多层布局容器组件，目前还没有创建类，先返回以下组件
        return new CustomGroup();
    }


}
