package com.digiwin.mobile.mobileuibot.core.layout.generator;

import com.digiwin.mobile.mobileuibot.core.component.BaseLayoutMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.layout.LayoutGeneratorPreprocessData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * <p>功能描述：单层布局生成器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: SinglePatternLayoutGenerator
 * @Author: zaregoto
 * @Date: 2023/3/15 11:42
 */
@Slf4j
@Component("singlePatternLayoutGenerator")
public class SinglePatternLayoutGenerator implements LayoutGenerator {

    @Override
    public String getType() {
        return MobileLayoutTypeEnum.SINGLE_PATTERN_LAYOUT.getValue();
    }

    @Override
    public BaseLayoutMobileComponent generate(LayoutGeneratorPreprocessData preprocessData) {
        int renderVersion = preprocessData.getRenderVersion();
        if (MobileRenderMetaData.RENDER_VERSION_1 == renderVersion) {
            return this.generateUseCustomGroup(preprocessData);
        } else if (MobileRenderMetaData.RENDER_VERSION_2 == renderVersion) {
            return this.generateUseSingleListContainer(preprocessData);
        } else {
            return this.generateUseCustomGroup(preprocessData);
        }
    }

    private CustomGroup generateUseCustomGroup(LayoutGeneratorPreprocessData preprocessData) {
        // FIXME 初始化单层布局组件（v1），后续可增加初始化操作
        return CustomGroup.create("", CustomGroupStyleTypeEnum.STYLE_INPUT_FORM);
    }

    private SingleListContainer generateUseSingleListContainer(LayoutGeneratorPreprocessData preprocessData) {
        // 初始化单层布局组件（v2），后续可增加初始化操作
        return new SingleListContainer<>();
    }
}
