package com.digiwin.mobile.mobileuibot.core.mobileappconfig;

import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：移动平台的应用配置类，用于保存在移动平台呈现的应用配置信息</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileAppConfig
 * @Author: Zaregoto
 * @Date: 2022/6/22 17:15
 */
@Document(collection = "mobileAppConfig")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MobileAppConfig implements Serializable {
    private static final long serialVersionUID = -8918941343984783076L;

    /**
     * 默认公司ID，表示子公司鼎捷移动
     */
    public static final String DEFAULT_COMPANY_ID = "10000";
    /**
     * 鼎捷公司ID，表示母公司鼎捷软件
     */
    public static final String DIGIWIN_COMPANY_ID = "1000";

    @Field("_id")
    private String id;
    /**
     * 应用所属公司ID
     */
    private String companyId;

    /**
     * 来源系统名称。比如athena，iam等，也可以是外部如SAP、Oracle的系统
     */
    private String sourceName;

    /**
     * 应用的编码
     */
    private String appCode;

    /**
     * 应用的报表配置
     */
    private MobileAppReportConfig reportConfig;

    /**
     * 任务过滤设置项是否有效。
     * 本设置为true时，则本设置是开启有效的；为false时，则本设置是关闭无效的。
     * 它的优先级最高。
     */
    private Boolean valid;

    /**
     * 不同环境的设置项。
     * 优先级低于valid
     */
    private List<EnvScope> envScopes;

    /**
     * 根据当前启动的环境类型，判断当前页面过滤设置是否生效。
     *
     * @param appEnvType
     * @return true-生效，false-不生效
     */
    public Boolean validWithAppEnvType(final String appEnvType) {
        // 如果没有配置页面可使用的环境，则表示不知道在哪个环境可使用，故直接返回false，表示不匹配
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            boolean valid = envScope.getValid();
            if (appEnvType.equals(type)) {
                result = valid;
                break;
            }
        }
        return result;
    }
}
