package com.digiwin.mobile.mobileuibot.core.mobileappconfig;

import java.util.List;

/**
 * <p>功能描述：MobileAppsConfig类的服务类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileAppConfigService
 * @Author: Zaregoto
 * @Date: 2022/6/22 17:34
 */
public interface MobileAppConfigService {

    List<MobileAppConfig> listMobileAppConfigsByCompanyId(String companyId);

    List<MobileAppConfig> listMobileAppConfigsBySourceName(String sourceName);

    List<MobileAppConfig> listMobileAppConfigsByCompanyIdAndSourceName(String companyId, String sourceName);

    MobileAppConfig getMobileAppConfig(String companyId, String sourceName, String appsCode);

    /**
     * 获取属于鼎捷移动子公司的应用
     *
     * @return
     */
    List<MobileAppConfig> listMobileAppConfigsBelongDefaultCompanyId();

    /**
     * 获取属于鼎捷软件母公司的应用
     *
     * @return
     */
    List<MobileAppConfig> listMobileAppConfigsBelongDigiwinCompanyId();
}
