package com.digiwin.mobile.mobileuibot.core.mobileappconfig;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileAppConfigServiceImpl
 * @Author: Zaregoto
 * @Date: 2022/6/22 17:38
 */
@Service("mobileAppConfigService")
public class MobileAppConfigServiceImpl implements MobileAppConfigService {

    private static final Logger logger = LoggerFactory.getLogger(MobileAppConfigServiceImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<MobileAppConfig> listMobileAppConfigsByCompanyId(String companyId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("companyId").is(companyId));

        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    @Override
    public List<MobileAppConfig> listMobileAppConfigsBySourceName(String sourceName) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("sourceName").is(sourceName));

        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    @Override
    public List<MobileAppConfig> listMobileAppConfigsByCompanyIdAndSourceName(String companyId, String sourceName) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("companyId").is(companyId));
        query.addCriteria(Criteria.where("sourceName").is(sourceName));

        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    @Override
    public MobileAppConfig getMobileAppConfig(String companyId, String sourceName, String appsCode) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("companyId").is(companyId));
        query.addCriteria(Criteria.where("sourceName").is(sourceName));
        query.addCriteria(Criteria.where("appsCode").is(appsCode));

        return this.mongoTemplate.findOne(query, MobileAppConfig.class);
    }

    @Cacheable(value = "defaultMobileAppConfigs")
    @Override
    public List<MobileAppConfig> listMobileAppConfigsBelongDefaultCompanyId() {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("companyId").is(MobileAppConfig.DEFAULT_COMPANY_ID));

        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }

    @Cacheable(value = "digiwinMobileAppConfigs")
    @Override
    public List<MobileAppConfig> listMobileAppConfigsBelongDigiwinCompanyId() {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("companyId").is(MobileAppConfig.DIGIWIN_COMPANY_ID));

        return this.mongoTemplate.find(query, MobileAppConfig.class);
    }
}
