package com.digiwin.mobile.mobileuibot.core.mobileappconfig;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：移动平台应用的报表配置类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileAppReportConfig
 * @Author: Zaregoto
 * @Date: 2022/6/22 17:30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MobileAppReportConfig implements Serializable {
    private static final long serialVersionUID = -4153453958029661488L;

    /**
     * 是否有TBB报表
     */
    private Boolean hasTbbReport;

    /**
     * 是否有报表
     *
     * @return
     */
    public boolean hasReport() {
        return this.getHasTbbReport();
    }
}
