package com.digiwin.mobile.mobileuibot.core.pagesetting;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * <p>功能描述：描述页面和页面结构的模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageSetting
 * @Author: Zaregoto
 * @Date: 2021/4/21 3:32
 */
@Document(collection = "pageSetting")
public class PageSetting implements Serializable {
    private static final long serialVersionUID = -643884021224101542L;

    @Field(value = "_id")
    private String pageId;
    private String pageTitle;
    /**
     * 是否系统默认页面
     * true表示是平台页面(受设计器配置影响)，false表示是给应用定制开发的页面（不受设计器配置影响）
     */
    private Boolean systemDefault;
    private UiBotModel pageModel;

    /**
     * @see com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation#getPageId()
     */
    private String pageFilterId;

    private String tenantId;

    public PageSetting() {
    }

    public String getPageId() {
        return pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public Boolean getSystemDefault() {
        return systemDefault;
    }

    public void setSystemDefault(Boolean systemDefault) {
        this.systemDefault = systemDefault;
    }

    public UiBotModel getPageModel() {
        return pageModel;
    }

    public void setPageModel(UiBotModel pageModel) {
        this.pageModel = pageModel;
    }

    public String getPageFilterId() {
        return pageFilterId;
    }

    public void setPageFilterId(String pageFilterId) {
        this.pageFilterId = pageFilterId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }
}
