package com.digiwin.mobile.mobileuibot.core.pagesetting;

/**
 * <p>功能描述：页面pageId内置值，等同于组件库中的基础功能页面。
 * 同时也参考了<code>AthenaMobileNotificationCategoryEnum</code>内部的分类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageSettingIdPresetEnum
 * @Author: Zaregoto
 * @Date: 2021/4/21 3:39
 */
public enum PageSettingIdPresetEnum {

    //V2移动端门户首页
    INDEX_PORTAL,
    //三方待办(刷新使用)
    FLASH_TRIPARTITE_TODO,
    //我的任务(刷新使用)
    FLASH_MY_TODO,
    //我的项目(刷新使用)
    FLASH_MY_PROJECT,
    // APP主页-基础
    INDEX,
    //游客模式主页
    INDEX_TOURIST_MODE,
    //无租户账号首页
    INDEX_NO_TENANT,

    // APP主页-什么都没有
    INDEX_NO_WORK,
    // APP主页-什么都有
    INDEX_HAS_WORK,
    // APP主页-只有任务没有项目
    INDEX_HAS_TASK_WORK,
    // APP主页-员工在未完成账号设定情况下，不可使用雅典娜，做「强提醒」管控 页面
    INDEX_NON_SUPER_ADMIN_NOT_SET_ACCOUNT,
    // APP主页-在途宝 司机首页，无车辆信息
    INDEX_DRIVER_NO_VEHICLE_ZTB,

    //通讯录页面
    CONTACTS,
    //我的-页面
    ME,
    // APP设置页
    SETTING,
    // APP登录页
    LOGIN,
    // APP工作台
    DASHBOARD,
    // GPT移动入口
    GPT_AI,
    // APP通知页
    NOTIFICATION_PAGE,

    // 三方待办页面
    MOBILE_TRIPARTITE_TODO,

    // APP我的待办页
    MOBILE_MY_TODO,
    // APP我的任务详情页(签核型)
    MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL,
    // APP我的任务详情页(签核型) 条目详情
    MOBILE_MY_BIZ_APPROVAL_TASK_ITEM_DETAIL,
    // APP我的任务详情页(回报型)
    MOBILE_MY_BIZ_REPORT_TASK_DETAIL,
    // APP我的任务详情页（通用处理型）
    MOBILE_MY_BIZ_PROCESS_TASK_DETAIL,
    //APP行事历任务详情页(回报型)
    MOBILE_MANUAL_TASK_DETAIL,
    //APP行事历任务详情页创建
    MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE,

    // 定制 PATTERN==CUSTOM 类型任务卡详情
    MOBILE_CUSTOM_PATTERN_TASK_DETAIL,

    // APP任务签核进度
    MOBILE_APPROVAL_TASK_PROGRESS,
    // APP项目助理页
    MOBILE_PROJECT_ASSISTANT,
    // APP Athena助手页
    MOBILE_ATHENA_ASSISTANT,
    // APP内部个人消息页
    MOBILE_INTERNAL_PERSONAL,
    // APP系统消息页
    MOBILE_SYSTEM,

    // Athena 签核型任务 同意按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_AGREE,

    // Athena 签核型任务 不同意按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_DISAGREE,

    // Athena 签核型任务 退回重签按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_REAPPROVE,

    // Athena 签核型任务 退回重办按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_REEXECUTE,

    // Athena 签核型任务 加签按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_ADDTASK,

    // Athena 签核型任务 转派按钮 展示页面
    MOBILE_ATHENA_BIZ_APPROVAL_REASSIGN,

    // Athena 工作流 撤审按钮 展示页面
    MOBILE_ATHENA_WORKFLOW_ABORT,

    // Athena 签核型任务 明细条目的详情 展示页面
    MOBILE_ATHENA_DETAIL_ITEM_DETAIL,

    //Athena 通用解析的任务详情页面
    MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL,

    // Athena 项目进度列表页面
    MOBILE_ATHENA_PROJECT,

    //Athena 跳转到项目/任务列表页面
    MOBILE_JUMP_ATHENA_PROJECT_OR_TASK,

    // Athena 项目中控台 项目详情页面
    MOBILE_ATHENA_PROJECT_CC_PROJECT_DETAIL,

    // Athena 项目中控台 下级任务清单页面
    MOBILE_ATHENA_PROJECT_CC_NEXT_LEVEL_TASK_LIST,

    // Athena 项目中控台 下级任务清单页面
    MOBILE_ATHENA_PROJECT_NEXT_LEVEL_PROJECT_LIST,

    // Athena 体系云管家 项目详情页面
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL,

    //Athena 体系云管家 编辑计划页
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL,

    //Athena 体系云管家 编辑计划选择模板页
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_CHOOSE_TEMPLATE,

    //Athena 体系云管家 编辑任务页
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_TASK,

    //Athena 体系云管家 下级任务清单页面
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST,

    //Athena 体系云管家 过程备忘录详情页面
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROCESS_REMARK,

    // Athena 发起项目、项目创建页面
    MOBILE_PROJECT_CREATE,
    // APP发起项目详情页(模型驱动手动发起项目(tmActivityId=StartNode_*******))
    MOBILE_PROJECT_CREATE_DATA_ENTRY_DRIVEN_DETAIL,

    // Athena SSC 员工入职第一天 任务详情页面
    MOBILE_ATHENA_SSC_EMPLOYEE_INDUCTION_TASK_DETAIL,

    // Athena SSC 员工考勤确认 任务详情页面
    MOBILE_ATHENA_SSC_EMPLOYEE_ATTEN_CONFIRM_TASK_DETAIL,

    //设计变更详情页
    MOBILE_ATHENA_ECN_PROJECT_DETAIL,
    //设计变更详情条目详情
    MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL,

    //标准项目详情页
    MOBILE_ATHENA_STANDARD_PROJECT_DETAIL,

    // Athena 智互联 一物一码 打印任务详情页面
    MOBILE_ATHENA_ZHILINK_BARCODEMAN_PRINT_TASK_DETAIL,

    // Athena 智互联 一物一码 扫码粘贴任务详情页面
    MOBILE_ATHENA_ZHILINK_BARCODEMAN_PASTE_TASK_DETAIL,

    // Athena 智互联 一物一码 扫码出厂任务详情页面
    MOBILE_ATHENA_ZHILINK_BARCODEMAN_CHECKOUT_TASK_DETAIL,

    // Athena 智互联 一物一码 扫码粘贴任务详情明细
    MOBILE_ATHENA_ZHILINK_PASTE_DETAIL_ITEM_DETAIL,

    // 搜索-NLP智能搜索
    MOBILE_SMART_SEARCH,

    // 搜索-结果项详情页
    MOBILE_SEARCH_ITEM_DETAIL,

    //搜索-结果项列表页
    MOBILE_SEARCH_ITEM_LIST,

    //左滑辅助资讯页面
    MOBILE_LEFT_SLIP,

    // Athena 项目中控台 PCC尾阶段任务详情
    MOBILE_ATHENA_PROJECT_CC_TAIL_TASK_DETAIL,

    // Athena  体系云管家尾阶段任务详情
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_TAIL_TASK_DETAIL,

    // Athena 项目中控台 PCC料件详情
    MOBILE_ATHENA_PROJECT_CC_MATERIAL_DETAIL,

    //Athena  体系云管家尾阶段料件详情
    MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_MATERIAL_DETAIL,

    // Athena 聚合搜索列表页
    MOBILE_ATHENA_SEARCH_ITEM_LIST,

    // Athena 聚合搜索详情页
    MOBILE_ATHENA_SEARCH_ITEM_DETAIL,

    // Athena 工时回报条目详情列表
    MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST,
    // Athena 工时回报数量确认列表
    MOBILE_ATHENA_APC_WORKING_HOUR_QUANTITY_CONFIRM_LIST,

    // Athena 工时支援条目详情列表
    MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST,

    // Athena 异常回报条目列表
    MOBILE_ATHENA_APC_ABNORMAL_REPORT_LIST,

    // Athena APC转派的底部弹窗
    MOBILE_ATHENA_APC_APPROVAL_REASSIGN_BOTTOM,

    // Athena APC处理的底部弹窗
    MOBILE_ATHENA_APC_HANDEL_BOTTOM,

    // Athena 工时回报明细详情页
    MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_DETAIL,

    // Athena 进度回报条目详情列表
    MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_LIST,

    // Athena 进度回报明细详情页
    MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_DETAIL,

    MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_MKP_DETAIL,

    // Athena 异常回报明细详情页
    MOBILE_ATHENA_APC_ABNORMAL_REPORT_DETAIL,

    // Athena 异常结案明细详情页
    MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_DETAIL,

    //管理异常套件任务详情页面
    MOBILE_MY_BIZ_ASSISTAN_TASK_DETAIL,

    //乾冶租户客制
    MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC,

    //在途宝 货物出货任务 修改为新版货物装车
    MOBILE_ZTB_SHIPPING_TASK,

    //在途宝 货物出货任务-货运/运单二维码底部开窗页面
    MOBILE_ZTB_SHIPPING_TASK_QR_CODE,

    //在途宝 货物出货任务-车辆信息页面
    MOBILE_ZTB_SHIPPING_TASK_VEHICLE_INFO,

    //在途宝 扫码接单页面
    MOBILE_ZTB_SCAN_RECEIVE_ORDER,

    //在途宝 货物发车
    MOBILE_ZTB_GOODS_DEPARTURE,

    //在途宝 货物装车
    MOBILE_ZTB_GOODS_LOADING,

    //在途宝 货物装车-车辆信息页面
    MOBILE_ZTB_GOODS_LOADING_VEHICLE_INFO,

    //在途宝 车辆信息新增/编辑页面
    MOBILE_ZTB_CAR_MESSAGE,
    // 我的车辆
    MOBILE_ZTB_CAR_LIST,
    // 车辆码
    MOBILE_ZTB_CAR_CODE,

    //在途宝 运输在途页面
    MOBILE_ZTB_TRANSPORT,

    //在途宝，运输在途-收货排程页面
    MOBILE_ZTB_TRANSPORT_SHIPPING_SCHEDULE,

    //在途宝，运输在途-转运车辆页面
    MOBILE_ZTB_TRANSPORT_VEHICLE_INFO,

    //在途宝，运输在途-异常报警页面
    MOBILE_ZTB_TRANSPORT_ABNORMAL_ALARM,

    //在途宝，运输转运代理-异常报警页面
    MOBILE_ZTB_TRANSPORT_FORWARDING_ALARM,

    //在途宝，项目发起--收货排程更改页面
    MOBILE_ZTB_RECEIPT_SCHEDULE_CHANGE,

    //在途宝，收货准备页面
    MOBILE_ZTB_RECEIPT_PREPARATION,

    //在途宝改版，回单签字
    MOBILE_ZTB_RECEIPT_SIGNATURE,

    //在途宝，收货排程修改页面
    MOBILE_ZTB_MODIFICATION_RECEIPT_SCHEDULE,

    //在途宝，收货准备确认页面
    MOBILE_ZTB_CONFIRMATION_RECEIPT_PREPARATION,

    //在途宝，收货确认页面  改版为：采卸收货
    MOBILE_ZTB_RECEIPT_CONFIRMATION,

    //在途宝，收货确认的拒收
    MOBILE_ZTB_RECEIPT_CONFIRMATION_REJECTION,

    //在途宝，货运信息明细页面
    MOBILE_ZTB_CARGO_INFORMATION,

    //在途宝改版，货物清单页面
    MOBILE_ZTB_CARGO_INFORMATION_LIST,

    //在途宝，项目详情，物流详情界面
    MOBILE_ZTB_PROJECT_LOGISTICS,

    //转派记录页面
    MOBILE_ATHENA_REASSIGN_REPORT,

    //布局解析页面
    MOBILE_ATHENA_UIBOT_UNIVERSAL_PARSE,

    //项目分享给他人Athena页面
    MOBILE_ATHENA_SHARE_OTHERS,

    //报表列表页面
    MOBILE_ATHENA_REPORT_LIST,
    //ABI报表展示页面
    MOBILE_ATHENA_ABI_REPORT_DETAIL,

    //ABI报表解析页面
    MOBILE_ATHENA_ABI_REPORT_INFO,

    //底部弹窗提示信息页面
    MOBILE_ATHENA_BOTTOM_WINDOW_INFO,

    //团队项目列表页
    MOBILE_ATHENA_TEAM_PROJECT,

    //团队任务列表页
    MOBILE_ATHENA_TEAM_TASK,

    // 进度回报任务提交提示信息页
    MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_SUBMIT,

    // 主管查看在线人员情况-依状态查阅
    MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_STATE,
    // 主管查看在线人员情况-依组别查阅
    MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP,
    // 主管查看在线人员情况-依组别查阅-详情
    MOBILE_ATHENA_APC_DIRECTOR_CHECK_PERSONNEL_ONLINE_GROUP_DETAIL,

    //基础资料录入-入口界面
    MOBILE_BASIC_DATA_ENTRANCE,
    //基础资料录入-录入页面 -- 作用于：单档多栏(模型驱动)
    MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE,
    //基础资料录入-浏览页面 -- 作用于：单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动)
    MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE,
    //基础资料录入-编辑页面 -- 设计器配置此值
    MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE,

    //在途宝--地址簿列表页
    MOBILE_ZTB_ADDRESS_BOOK,

    //在途宝--修改地址页面
    MOBILE_ZTB_MODIFIY_ADDRESS,

    //在途宝-已装车页面详情
    MOBILE_ZTB_DELIVERY_LOADED_ITEM,

    //APC进度回报-待处理异常清单
    MOBILE_APC_PROJECT_SCHEDULE_REPORT_WAIT_DEAL_LIST,

    //APC请求支援--底部弹窗
    MOBILE_ATHENA_APC_SUPPORT_BOTTOM,

    //APC数量转移--底部弹窗
    MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS,
    MOBILE_ATHENA_APC_TRANSFER_QUANTITY_MKP_DETAILS,
    //APC支援需求页面
    MOBILE_ATHENA_APC_SUPPORT_NEEDS,

    //在途宝
    MOBILE_ZTB_DELIVERY_LOAD_EDIT_ITEM,

    //APC时令上线
    MOBILE_ATHENA_APC_WORK_SHOP_ONLINE,

    //APC时令上线的去处理页面
    MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_DEAL_DETAIL,

    //APC时令上线的撤回页面
    MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL,

    // Athena 异常结案退回底部弹窗页
    MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_RETURN_BOTTOM,

    // Athena 异常结案结案底部弹窗页
    MOBILE_ATHENA_APC_ABNORMAL_CLOSURE_PROGRESS_BOTTOM,

    // Athena 异常班组派工页面
    MOBILE_ATHENA_APC_TEAM_DISPATCH,

    // Athena 异常班组派工页面去处理页面
    MOBILE_ATHENA_APC_TEAM_DISPATCH_DEAL_DETAIL,

    // Athena 异常班组派工待处理异常清单页面
    MOBILE_ATHENA_APC_TEAM_DISPATCH_ABNORMAL_REPORT_DETAIL,

    //Athena APC的人员清单跳转页面
    MOBILE_APC_ONLINE_REPORT,

    //在途宝-上传回单弹窗
    MOBILE_ZTB_RECEIPT_SIGNATURE_UPLOAD,


    //在途宝-签字弹窗
    MOBILE_ZTB_RECEIPT_SIGNATURE_SIGN,

    //在途宝-扫码后确认提交
    MOBILE_ZTB_ARRIVAL_SCAN_CONFIRM,

    //在途宝-偏移预警
    MOBILE_ZTB_TRANSPORT_SHIFTING_ABNORMAL_ALARM,

    //在途宝-长时间提留预警
    MOBILE_ZTB_TRANSPORT_STOP_ABNORMAL_ALARM,

    //在途宝-电子围栏列表
    MOBILE_ZTB_ELECTRONIC_FENCE_LIST,

    //在途宝-电子围栏详情
    MOBILE_ZTB_ELECTRONIC_FENCE_DETAIL,

    //在途宝-安排入厂工作
    MOBILE_ZTB_TRANSPORT_COMING_SOON,

    //在途宝-运输转运代理
    MOBILE_ZTB_TRANSPORT_FORWARDING_AGENT,

    //在途宝-入厂指引
    MOBILE_ZTB_TRANSPORT_FACTORY_GUIDE,

    //在途宝-入厂凭证
    MOBILE_ZTB_TRANSPORT_FACTORY_VOUCHER,

    // Athena 领料通知
    MOBILE_ATHENA_MATERIAL_NOTICE_LIST,

    // Athena 委外报工列表
    MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_LIST,

    // Athena 委外报工待处理详情
    MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_DETAIL,

    // Athena 委外报工报工明细详情
    MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_TASK_DETAIL,

    // Athena 委外报工已完成详情
    MOBILE_ATHENA_OUTSOURCE_WORK_REPORT_COMPLETE_DETAIL,

    // Athena 制令上线场域查看详情-未生效
    MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL,
    // Athena 制令上线场域查看详情-生效
    MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_AREA_DETAIL_TAKE_EFFECT,

    // Athena 合并工时列表页
    MOBILE_ATHENA_APC_MERGE_WORK_HOUR_LIST,

    // Athena 合并工时调整报工数量
    MOBILE_ATHENA_APC_MERGE_WORK_HOUR_QUANTITY_CONFIRM,

    // Athena 试研北斗试验过程记录
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD,

    //Athena 试研北斗试验过程记录的参数修改页
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_PARAM,

    //Athena 试研北斗试验过程记录的编辑物料页面
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_MODIFY_MATERIAL,

    //Athena 试研北斗试验过程记录的下一层级页面
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_NEXT_STEP,

    //Athena 试研北斗试验结果确认
    MOBILE_ATHENA_TBDS_RESULT_CONFIRMATION,

    // Athena 试研北斗试验过程记录驳回提交
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REJECT_SUBMIT,

    //Athena 试验北斗试验记录报工提交
    MOBILE_ATHENA_TBDS_PRODUCTION_PROCESS_RECORD_REPORT_SUBMIT,

    // Athena 北斗报工详情
    MOBILE_ATHENA_TBDS_PRODUCTION_PROGRESS_REPORT_DETAIL,

    //Athena 对账周报列表页
    MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_LIST,

    //Athena 对账周报详情页
    MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_DETAIL,

    //Athena 对账周报进度回报页
    MOBILE_ATHENA_RECONCILIATION_PROGRESS_REPORT,

    //Athena 对账周报通知请款页
    MOBILE_ATHENA_RECONCILIATION_PROGRESS_CALL_PAYMENT,

    // Athena V2版--任务卡--默认解析--条目详情页面通用解析页面
    MOBILE_ATHENA_DESIGNER_UNIVERSAL_PARSING_PAGE,
    // Athena V2版--数据录入--默认解析--条目详情页面通用解析页面
    MOBILE_ATHENA_BASIC_DATA_UNIVERSAL_PARSING_PAGE,
    // Athena V2版--任务卡--数据驱动DSL--从bpmdata中获取字段属性--条目详情页面通用解析页面
    MOBILE_ATHENA_DATA_DRIVEN_DSL_UNIVERSAL_PARSING_PAGE,
    // Athena V2版--数据录入--模型驱动--浏览页面--视图驱动DSL--条目详情页面通用解析页面
    MOBILE_ATHENA_BASIC_DATA_BROWSE_DETAIL_VIEW_DRIVEN_PARSING_PAGE,
    // Athena V2版--任务卡--数据录入--模型驱动--流程设计--生成的任务卡--条目详情页面通用解析页面
    MOBILE_ATHENA_BIZ_DATA_ENTRY_DRIVEN_ITEM_PARSING_PAGE,

    // Athena 流程进度固定页面
    MOBILE_ATHENA_WORKFLOW_PROGRESS_FIXATION_PAGE,

    // Athena 试验优测结果录入的子条目定制详情页
    MOBILE_ATHENA_INSPECTION_RESULTS_REGISTRATION_SUB_ITEM_CUSTOMIZE_DETAIL,

    //Athena 手动报工前置任务详情页
    MOBILE_ATHENA_PREVIOUS_MANUAL_TASK_DETAIL,

    // Athena 备注详情页
    MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM,

    //Athena 手动报工代为报工批量选择执行人页
    MOBILE_ATHENA_REPLACE_REPORT_TASK_EXECUTOR_DETAIL,

    //Athena 手动报工代为报工详情页
    MOBILE_ATHENA_REPLACE_REPORT_TASK_DETAIL,

    // 敏捷数据详情页
    MOBILE_ATHENA_AGILE_DATA_DETAIL_PAGE,

    // Athena V2版-发起项目，通用解析页面
    MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE,

    // Athena V2版-发起项目，通用解析的详情页面
    MOBILE_ATHENA_START_PROJECT_DSL_UNIVERSAL_PARSING_PAGE,

    //第三方h5页面：不支持查看任务详情,返回空组件
    MOBILE_ATHENA_EMPTY_PAGE,

    // APP我的任务详情页(tmPattern=BUSINESS、tmCategory=DATA_ENTRY_DRIVEN)
    MOBILE_MY_BIZ_DATA_ENTRY_DRIVEN_TASK_DETAIL,

    // APP我的任务详情页(随心控(人工型：code+_task_manual;审核型：code+_task_approve))
    MOBILE_MY_BIZ_SMART_ADJUST_TASK_DETAIL,

    //人员状况合并工单详情页
    MOBILE_ATHENA_APC_PERSONEL_STATE_MERGE_DETAIL,

    //人员状况详细信息页
    MOBILE_ATHENA_APC_PERSONEL_STATE_ONLINE_DETAIL,

    // Athena V2版-- cardList 转 table 页面
    MOBILE_ATHENA_CARDLIST_CONVERT_TABLE_PAGE,

    //PCC-未启动的项目卡页面
    MOBILE_ATHENA_PROJECT_PCC_EMPTY_PAGE,

    //PCC-报工查询任务卡页面
    MOBILE_ATHENA_PCC_WORK_REPORT_INFO_PAGE,

    // PCC-报工查询通用解析的详情页面
    MOBILE_ATHENA_PCC_WORK_REPORT_INFO_DSL_UNIVERSAL_PARSING_PAGE,

    // 扫码搜索-任务列表页
    MOBILE_ATHENA_QRCODE_SEARCH_TODO_LIST,

    // Athena 项目计划 项目详情页面
    MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_DETAIL,

    // Athena 项目计划 项目详情基础信息页面
    MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_BASIC_DETAIL,

    // APC-机位生产进度页面
    MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_PAGE,
    // APC-机位生产进度-通用解析的详情页面
    MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_UNIVERSAL_PARSING_PAGE,

    // APC-上传附件页面-目前进度回报和工时回报使用
    MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE,

    // APC-附件详情页面-目前进度回报和工时回报使用
    MOBILE_ATHENA_APC_COMMON_ATTACHMENT_DETAIL_PAGE,

    // Athena 工作台页面
    MOBILE_ATHENA_WORKBENCH_PAGE,
    // Athena 工作台页面-通用解析的详情页面
    MOBILE_ATHENA_WORKBENCH_UNIVERSAL_PARSING_PAGE,

    // Athena 项目卡--项目详情页面
    MOBILE_ATHENA_PROJECT_V2_PAGE,
    // Athena 项目卡--里程碑下--项目详情页面
    MOBILE_ATHENA_PROJECT_MILESTONE_PAGE,
    MOBILE_ATHENA_PROJECT_MILESTONE_UNIVERSAL_PARSING_PAGE,
    //发现
    MOBILE_ATHENA_FOUND_PAGE,

    ;

    public static PageSettingIdPresetEnum getEnumByName(String name) {
        String tester = name;
//        if (name.startsWith(MOBILE_INTERNAL_PERSONAL.toString())) {
//            tester = name.substring(MOBILE_INTERNAL_PERSONAL.toString().length());
//        }

        for (PageSettingIdPresetEnum pageIdEnum : PageSettingIdPresetEnum.values()) {
            if (pageIdEnum.name().equalsIgnoreCase(tester)) {
                return pageIdEnum;
            }
        }
        return null;
    }
}