package com.digiwin.mobile.mobileuibot.core.pageskeleton;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 骨架屏配置
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MobileSkeleton implements Serializable {
    private static final long serialVersionUID = 8331621976476149661L;
    /**
     * /// 一般類型
     * blank_type1, //空白間隔 10101
     * image_type1, //方形圖 10201
     * image_type2, //圓圖 10202
     * tag_type1, //標籤（共 1 個）10301
     * tag_type2, //標籤（共 2 個）10302
     * tag_type3, //標籤（共 3 個）10303
     * button_rect_type1, //按鈕（圓角；共 1 個）10401
     * button_rect_type2, //按鈕（圓角；共 2 個）10402
     * button_rect_type3, //按鈕（圓角；共 3 個）10403
     * button_round_type1, //按鈕（圓邊；共 1 個）10501
     * button_round_type2, //按鈕（圓邊；共 2 個）10502
     * button_round_type3, //按鈕（圓邊；共 3 個）10503
     * item_type1, //項目（圓角；長度:1）10601
     * item_type2, //項目（圓角；長度:0.8）10602
     * item_type3, //項目（圓角；長度:0.6）10603
     * item_type4, //項目（圓角；長度:0.4）10604
     * details_type1, //詳情（長度:1，共3行）10701
     * details_type2, //詳情（長度:1，共5行）10702
     * details_type3, //詳情（詳情長度:0.6、1、0.7，共3行）10703
     * article_type1, //文章（標題長度:1；內文長度:0.6，共1行）10801
     * article_type2, //文章（標題長度:1；內文長度:0.6，共2行）10802
     * article_type3, //文章（標題長度:0.6；內文長度:1，共1行）10803
     * article_type4, //文章（標題長度:0.6；內文長度:1，共2行）10804
     * graphics_rect_type1, //方圖文（標題長度:1;內文長度:0.6，共1行）10901
     * graphics_rect_type2, //方圖文（標題長度:1;內文長度:0.6，共2行）10902
     * graphics_round_type1, //圓圖文（標題長度:1;內文長度:0.6，共1行）11001
     * graphics_round_type2, //圓圖文（標題長度:1;內文長度:0.6，共2行）11002
     * /// 卡片類型
     * card_article_type1, //卡片-文章（標題長度:1；內文長度:0.6，共1行）20801
     * card_article_type2, //卡片-文章（標題長度:1；內文長度:0.6，共2行）20802
     * card_article_type3, //卡片-文章（標題長度:0.6；內文長度:1，共1行）20803
     * card_article_type4, //卡片-文章（標題長度:0.6；內文長度:1，共2行）20804
     * card_details_type1, //卡片-詳情（詳情長度:1，共3行）20701
     * card_details_type2, //卡片-詳情（詳情長度:1，共5行）20702
     * card_details_type3, //卡片-詳情（詳情長度:0.6、1、0.7，共3行）20703
     * card_graphics_rect_type1, //卡片-方圖文（標題長度:1；內文長度:0.6，共1行）20901
     * card_graphics_rect_type2, //卡片-方圖文（標題長度:1；內文長度:0.6，共2行）20902
     * card_graphics_round_type1, //卡片-圓圖文（標題長度:1；內文長度:0.6，共1行）21001
     * card_graphics_round_type2, //卡片-圓圖文（標題長度:1；內文長度:0.6，共2行）21002
     */
    private String skeletonName;
}