package com.digiwin.mobile.mobileuibot.core.pagetaskrelation;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.EnvScope;
import com.digiwin.mobile.mobileuibot.openapi.designer.enums.DataVersionEnum;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterParam;
import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：页面与任务关联设置数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageTaskRelation
 * @Author: Zaregoto
 * @Date: 2021/11/9 16:36
 */
@Data
@Document(collection = "pageTaskRelation")
public class PageTaskRelation implements Serializable {

    private static final long serialVersionUID = 4759058879095295701L;

    @Id
    private String id;
    private String source;

    /**
     * @see com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting#getPageId()
     */
    private String pageId;

    /**
     * 任务详情用外部链接打开时的url
     */
    private String url;

    /**
     * 页面类型
     *
     * @see PageTaskRelationCategoryEnum
     */
    private String category;
    private TaskFilterParam param;

    /**
     * 使用的环境范围设置
     */
    private List<EnvScope> envScopes;

    //***********从设计器来源时存储的相关信息******begin******************
    /**
     * 从哪来
     *
     * @see com.digiwin.mobile.mobileuibot.task.filter.TaskFilterFromEnum
     */
    private String from;
    private String createTime;
    private String updateTime;
    //************从设计器来源时存储的相关信息*******end****************

    /**
     * 应用code,注意：为空表示通用配置
     */
    private String appCode;
    /**
     * 数据版本
     * @see DataVersionEnum
     */
    private String version;

    /**
     * 根据当前启动的环境类型，判断当前页面过滤设置是否生效。
     *
     * @param appEnvType
     * @return true-生效，false-不生效
     */
    public Boolean validWithAppEnvType(final String appEnvType) {
        // 如果没有配置页面可使用的环境，则表示不知道在哪个环境可使用，故直接返回false，表示不匹配
        if (this.getEnvScopes() == null || this.getEnvScopes().isEmpty()) {
            return false;
        }
        Boolean result = false;
        for (EnvScope envScope : this.getEnvScopes()) {
            String type = envScope.getType();
            Boolean valid = envScope.getValid();
            if (appEnvType.equals(type)) {
                result = valid;
                break;
            }
        }
        return result;
    }

    /**
     * 判断是否和当前页面过滤设置的pattern及category匹配
     *
     * @param tmPattern
     * @param tmCategory
     * @return
     */
    public Boolean matchInPatternAndCategory(final String tmPattern, final String tmCategory) {
        if (null == tmPattern || null == tmCategory) {
            return false;
        }
        if (this.param == null) {
            return false;
        }
        String paramTmPattern = StringUtil.valueOf(this.param.getTmPattern());
        String paramTmCategory = StringUtil.valueOf(this.param.getTmCategory());
        if (!StringUtils.hasLength(paramTmPattern) && !StringUtils.hasLength(paramTmCategory)) {
            return false;
        }
        return (!StringUtils.hasLength(paramTmPattern) || paramTmPattern.equals(tmPattern))
                && (!StringUtils.hasLength(paramTmCategory) || paramTmCategory.equals(tmCategory));
    }

    /**
     * 判断是否和当前页面过滤设置的taskId及activityId匹配
     *
     * @param tmTaskId
     * @param tmActivityId
     * @return
     */
    public Boolean matchInTaskIdAndActivityId(final String tmTaskId, final String tmActivityId) {
        if (null == tmTaskId || null == tmActivityId) {
            return false;
        }
        if (this.param == null) {
            return false;
        }
        String paramTmTaskId = StringUtil.valueOf(this.param.getTmTaskId());
        String paramTmActivityId = StringUtil.valueOf(this.param.getTmActivityId());
        return (!StringUtils.hasLength(paramTmTaskId) || TaskFilter.match(tmTaskId.trim(), paramTmTaskId, this.param.getTmTaskIdMatch()))
                && TaskFilter.match(tmActivityId, paramTmActivityId, this.param.getTmActivityIdMatch());
    }

    /**
     * 判断是否是 ：定制 PATTERN==CUSTOM 类型任务卡详情
     *
     * @return
     */
    public Boolean matchPatternIsCustom() {
        if (this.param == null) {
            return false;
        }
        return "CUSTOM".equals(this.param.getTmPattern());
    }

}
