package com.digiwin.mobile.mobileuibot.core.pagetaskrelation;

import java.util.List;

/**
 * <p>功能描述：页面与任务关联设置相关服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageTaskRelationService
 * @Author: Zaregoto
 * @Date: 2021/11/9 16:41
 */
public interface PageTaskRelationService {

//    /**
//     * 根据param参数找到一个Athena使用的页面任务关联设置
//     *
//     * @param param
//     * @return
//     */
//    PageTaskRelation findAthenaPageTaskRelation(Map<String, Object> param);

//    /**
//     * 找到所有Athena使用的页面任务关联设置
//     *
//     * @return
//     */
//    List<PageTaskRelation> listAthenaPageTaskRelations();

    /**
     * 找到所有Athena使用的页面任务关联设置，并筛选出符合当前appEnvType的那些
     *
     * @param version 数据版本
     * @return List<PageTaskRelation> 符合条件的页面任务关联设置列表
     */
    List<PageTaskRelation> listAthenaPageTaskRelations(String version);

//    PageTaskRelation findPageTaskRelation(String source, Map<String, Object> param);

//    List<PageTaskRelation> listPageTaskRelations(String source);

//    /**
//     * 选择数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    PageTaskRelation selectByDesigner(String tmActivityId);
//
//    /**
//     * 删除数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    List<PageTaskRelation> deleteByDesigner(String tmActivityId);
//
//    /**
//     * 插入数据通过任务id
//     *
//     * @param tmActivityId
//     */
//    void insertByDesigner(String tmActivityId);

    /**
     * 根据appCode和version删除数据
     *
     * @param appCode 应用代号
     * @param version 数据版本
     */
    void deleteByCode(String appCode, String version);
    /**
     * 根据appCode和version查询数据
     *
     * @param appCode 应用代号
     * @param version 数据版本
     */
    List<PageTaskRelation> selectByCode(String appCode, String version);
    /**
     * 批量插入数据
     *
     * @param pageTaskRelations 数据列表
     */
    void batchInsert(List<PageTaskRelation> pageTaskRelations);
}
