package com.digiwin.mobile.mobileuibot.core.pagetaskrelation;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PageTaskRelationServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/11/9 16:41
 */
@Service("pageTaskRelationService")
public class PageTaskRelationServiceImpl implements PageTaskRelationService {

    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("secondMongoTemplate")
    private MongoTemplate secondMongoTemplate;

//    @Override
//    public PageTaskRelation findAthenaPageTaskRelation(Map<String, Object> param) {
//        return findPageTaskRelation(StringUtil.SOURCE_ATHENA, param);
//    }

//    @Override
//    public List<PageTaskRelation> listAthenaPageTaskRelations() {
//        return listPageTaskRelations(StringUtil.SOURCE_ATHENA);
//    }

    @Override
    public List<PageTaskRelation> listAthenaPageTaskRelations(String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
                .addCriteria(Criteria.where("version").is(version));
        return this.mongoTemplate.find(query, PageTaskRelation.class)
                .stream().filter(pageTaskRelation -> pageTaskRelation.validWithAppEnvType(AppContext.getEnvType()))
                .collect(Collectors.toList());
    }

//    @Override
//    public PageTaskRelation findPageTaskRelation(String source, Map<String, Object> param) {
//        Query query = new Query();
//        Criteria paramCriteria = new Criteria();
//        // FIXME 补充过滤器参数的查询条件

    ////        paramCriteria.getKey()
//        query.addCriteria(Criteria.where("source").is(source))
//                .addCriteria(paramCriteria);
//
//        return this.mongoTemplate.findOne(query, PageTaskRelation.class);
//    }

//    private List<PageTaskRelation> listPageTaskRelations(String source) {
//        Query query = new Query();
//        query.addCriteria(Criteria.where("source").is(source));
//        return this.mongoTemplate.find(query, PageTaskRelation.class);
//    }

//    @Override
//    public PageTaskRelation selectByDesigner(String tmActivityId) {
//        Query query = new Query();
//        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
//                .addCriteria(Criteria.where("category").is(PageTaskRelationCategoryEnum.DETAIL.getValue()))
//                .addCriteria(Criteria.where("param.tmActivityId").is(tmActivityId))
//                .addCriteria(Criteria.where("from").is(TaskFilterFromEnum.DESIGNER.getValue()));
//        return mongoTemplate.findOne(query, PageTaskRelation.class);
//    }
//
//    @Override
//    public List<PageTaskRelation> deleteByDesigner(String tmActivityId) {
//        Query query = new Query();
//        query.addCriteria(Criteria.where("source").is(StringUtil.SOURCE_ATHENA))
//                .addCriteria(Criteria.where("category").is(PageTaskRelationCategoryEnum.DETAIL.getValue()))
//                .addCriteria(Criteria.where("param.tmActivityId").is(tmActivityId))
//                .addCriteria(Criteria.where("from").is(TaskFilterFromEnum.DESIGNER.getValue()));
//        return mongoTemplate.findAllAndRemove(query, PageTaskRelation.class);
//    }
//
//    @Override
//    public void insertByDesigner(String tmActivityId) {
//        if (null != this.selectByDesigner(tmActivityId)) {
//            return;
//        }
//        PageTaskRelation pageTaskRelation = new PageTaskRelation();
//        pageTaskRelation.setSource(StringUtil.SOURCE_ATHENA);
//        pageTaskRelation.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
//        pageTaskRelation.setCategory(PageTaskRelationCategoryEnum.DETAIL.getValue());
//        TaskFilterParam param = new TaskFilterParam();
//        param.setTmActivityId(tmActivityId);
//        pageTaskRelation.setParam(param);
//        List<EnvScope> list = new ArrayList<>();
//        EnvScope prod = new EnvScope();
//        prod.setType(AppEnvTypeEnum.PRODUCTION.getEnvType());
//        prod.setValid(false);
//        list.add(prod);
//        EnvScope test = new EnvScope();
//        test.setType(AppEnvTypeEnum.TEST.getEnvType());
//        test.setValid(true);
//        list.add(test);
//        EnvScope dev = new EnvScope();
//        dev.setType(AppEnvTypeEnum.DEVELOP.getEnvType());
//        dev.setValid(true);
//        list.add(dev);
//        pageTaskRelation.setEnvScopes(list);
//        pageTaskRelation.setFrom(TaskFilterFromEnum.DESIGNER.getValue());
//        String time = DateTimeUtil.getTodayTimeUseDefaultPattern();
//        pageTaskRelation.setCreateTime(time);
//        pageTaskRelation.setUpdateTime(time);
//        this.mongoTemplate.insert(pageTaskRelation);
//    }
    @Override
    public void deleteByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("version").is(version));
        // AB库同时操作
        mongoTemplate.findAllAndRemove(query, PageTaskRelation.class);
        secondMongoTemplate.findAllAndRemove(query, PageTaskRelation.class);
    }

    @Override
    public List<PageTaskRelation> selectByCode(String appCode, String version) {
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode))
                .addCriteria(Criteria.where("version").is(version));
        List<PageTaskRelation> list = mongoTemplate.find(query, PageTaskRelation.class);
        return CollectionUtils.isEmpty(list) ? new ArrayList<>() : list;
    }

    @Override
    public void batchInsert(List<PageTaskRelation> pageTaskRelations) {
        if (CollectionUtils.isEmpty(pageTaskRelations)) {
            return;
        }
        // AB库同时操作
        mongoTemplate.insertAll(pageTaskRelations);
        secondMongoTemplate.insertAll(pageTaskRelations);
    }
}
