package com.digiwin.mobile.mobileuibot.core.rule;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: JsRuleServiceImpl
 * @Author: xujin
 * @Date: 2023/7/25 10:49
 */
@Service("jsRuleService")
public class JsRuleServiceImpl implements JsRuleService {

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<JsRule> findByPageId(String pageId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("pageId").is(pageId));
        return this.mongoTemplate.find(query, JsRule.class);
    }

    @Override
    public List<JsRule> findByTmActivityId(String tmActivityId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("tmActivityId").is(tmActivityId));
        return this.mongoTemplate.find(query, JsRule.class);
    }
}
