package com.digiwin.mobile.mobileuibot.core.rule;

/**
 * <p>功能描述：规则类别枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileUiBotRuleCategoryEnum
 * @Author: Zaregoto
 * @Date: 2021/6/24 17:57
 */
public enum RuleCategoryEnum {
    /**
     * 校验型规则
     */
    VALIDATE("validate"),

    /**
     * 联动型规则
     */
    RELATION("relation"),

    /**
     * 字段映射型规则
     * @since 20220218 OCR组件，SSC入职第一天任务卡. 用于将业务字段、OCR服务的字段和组件内容做映射配置
     */
    MAPPING("mapping")
    ;

    private final String category;

    RuleCategoryEnum(String category) {
        this.category = category;
    }

    public String getCategory() {
        return category;
    }
}
