package com.digiwin.mobile.mobileuibot.core.rule;

/**
 * <p>功能描述：针对规则设定的条件（condition），可使用的运算符的枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleConditionOperatorTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/1/28 19:14
 */
public enum RuleConditionOperatorTypeEnum {
    /**
     * 相等。表示与条件（condition）的值相等
     */
    EQUALS(1),

    /**
     * 不等。表示与条件（condition）的值不等
     */
    NOT_EQUALS(2),

    /**
     * 小于。表示小于条件（condition）的值，该条件（condition）值必须是数字型。
     */
    NUM_LESS_THAN(3),

    /**
     * 表示或，只要条件（condition）的数组值中有一个是成立的则表示返回true。该条件（condition）值必须是数组值
     * 格式和List<RuleValidCondition> validConditions一样。
     */
    EXIST_ONE_VALUE(4);

    private Integer type;

    RuleConditionOperatorTypeEnum(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public static RuleConditionOperatorTypeEnum getEnumByType(Integer type) {
        for (RuleConditionOperatorTypeEnum operatorTypeEnum : RuleConditionOperatorTypeEnum.values()) {
            if (operatorTypeEnum.getType().equals(type)) {
                return operatorTypeEnum;
            }
        }
        return null;
    }
}
