package com.digiwin.mobile.mobileuibot.core.rule;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * <p>功能描述：初始化类型的规则的配置参数</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleInitConfig
 * @Author: Zaregoto
 * @Date: 2022/2/6 20:10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RuleInitConfig implements Serializable {

    /**
     * 初始化时强制使用的组件（截止20220818为止还没用）
     */
    private String componentType;
    private String dataType;
    /**
     * 是否初始化时是可用的
     */
    private Boolean enable;
    /**
     * 是否初始化时是必填的
     */
    private Boolean required;
    /**
     * 必填校验的key
     */
    private String key;

}
