package com.digiwin.mobile.mobileuibot.core.rule;

import com.digiwin.mobile.mobileuibot.proxy.ocr.model.OcrData;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 目前仅当是字段映射型规则时会有值
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RuleMappingConfig implements Serializable {
    private static final long serialVersionUID = 2228939409602989713L;

    /**
     * 命中后UI Bot会将当前的layout作为整体解析，不再往下拆。并用于生成componentType指定的组件
     */
    private String searchFieldType;

    private Integer cardType;

    private String placeholder;

    List<OcrData> dataList = new ArrayList<>();

}
