package com.digiwin.mobile.mobileuibot.core.rule;

/**
 * <p>功能描述：规则的适用范围、阶段</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleScopeEnum
 * @Author: Zaregoto
 * @Date: 2021/6/23 11:38
 */
public enum RuleScopeEnum {
    /**
     * 当处于录入阶段时.
     */
    EDIT("EDIT"),

    /**
     * 当处于初始化阶段时.
     * eg.页面加载过程中，生成组件的阶段
     * 注意：每个字段的初始化规则应该只有一个
     */
    INIT("INIT")
    ;

    private String scope;

    RuleScopeEnum(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}
