package com.digiwin.mobile.mobileuibot.core.rule;

import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/6/24 18:24
 */
@Service("ruleService")
public class RuleServiceImpl implements RuleService {

    private static final Logger logger = LoggerFactory.getLogger(RuleServiceImpl.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<Rule> findByRulePath(String path) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("path").is(path));

        return this.mongoTemplate.find(query, Rule.class);
    }

    @Override
    public List<Rule> findByRulePathAndPageId(String path, String pageId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("path").is(path).and("pageId").is(pageId));

        return this.mongoTemplate.find(query, Rule.class);
    }

    @Override
    public List<Rule> findByRuleCategory(String category) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("category").is(category));

        return this.mongoTemplate.find(query, Rule.class);
    }

    @Override
    public List<Rule> findByRuleTenantId(String tenantId) {
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("tenantId").is(tenantId));

        return this.mongoTemplate.find(query, Rule.class);
    }

    //插入数组。慎用，可能会报错，报错原因是因为
    @Override
    public void insertRuleList(List<Rule> ruleList) {
        this.mongoTemplate.insert(ruleList);
    }

    //插入一条数据
    @Override
    public void insertRule(Rule oneRule) {
        this.mongoTemplate.insert(oneRule);
    }

    @Override
    public void updateRule(Rule oneRule) {
        ObjectId _id = new ObjectId(oneRule.getId());
        Query query = new Query();
        query.addCriteria(Criteria.where("valid").is(true));
        query.addCriteria(Criteria.where("_id").is(_id));
//        Rule r1 = this.mongoTemplate.findById(_id, Rule.class);
        this.mongoTemplate.updateMulti(query, Update.update("valid", false), Rule.class);
    }
}
