package com.digiwin.mobile.mobileuibot.core.rule;

import java.util.Objects;

/**
 * <p>功能描述：规则子类别枚举类。目前只有联动型规则才会使用。</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MobileUiBotRuleSubcategoryEnum
 * @Author: Zaregoto
 * @Date: 2021/6/24 17:59
 */
public enum RuleSubcategoryEnum {
    /**
     * 日期联动规则
     */
    DATE("date"),

    /**
     * 文字匹配联动规则
     */
    TEXT("text"),

    /**
     * 通用联动规则
     */
    COMMON("common");

    private String subcategory;

    RuleSubcategoryEnum(String subcategory) {
        this.subcategory = subcategory;
    }

    public String getSubcategory() {
        return subcategory;
    }

    public static RuleSubcategoryEnum getEnumByValue(String value) {
        for (RuleSubcategoryEnum testedEnum : RuleSubcategoryEnum.values()) {
            if (Objects.equals(testedEnum.getSubcategory(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
