package com.digiwin.mobile.mobileuibot.core.rule;

import java.util.regex.Pattern;

/**
 * <p>功能描述：规则对象处理的工具类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleUtil
 * @Author: Zaregoto
 * @Date: 2022/2/4 16:44
 */
public final class RuleUtil {

    /**
     * 使用正则，判断输入的表达式是否有效。使用正则：\$\{\w+\.{1}\w+\}
     * 表达式规则：
     * 1. ${ 开头，} 结尾
     * 2. .（半角句号）符号索引位置大于0。
     * @param expression 输入的表达式
     * @return true-表达式有效；false-表达式无效
     */
    public static boolean validExpression(String expression) {
        Pattern pattern = Pattern.compile("^\\$\\{\\w+\\.{1}\\w+\\}$");
        return pattern.matcher(expression).find();
    }

    /**
     * 判断输入字符串（大小写不敏感）是否是表达布尔值的字符串
     * @param value 输入字符串
     * @return true-字符串是表达布尔值的字符串；false-字符串不是表达布尔值的字符串
     */
    public static boolean validBooleanValue(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    /**
     * 解析表达式，并返回表达式中key的名称。
     * eg. 输入"${a.complete_rate}"字符串，则返回"complete_rate"字符串
     * @param expression 表达式字符串
     * @return 表达式中key的名称
     */
    public static String analyzeExpressionBizDataKey(String expression) {
        if (!RuleUtil.validExpression(expression)) {
            return "";
        }
        int dotIdx = expression.indexOf(".");
        int rightBracketIdx = expression.indexOf("}");

        return expression.substring(dotIdx + 1, rightBracketIdx);
    }
}
