package com.digiwin.mobile.mobileuibot.core.rule;

import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：规则实际是否生效的条件描述</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RuleValidCondition
 * @Author: Zaregoto
 * @Date: 2022/2/4 16:31
 */
@Data
public class RuleValidCondition {
    /**
     * 表达式内容。
     * 表达式规范：${[rulePath].[bizDataKey]}。eg. ${project_info.is_attachment}, ${project_info.is_confirm_date}
     */
    private String expression;
    private Integer conditionOperatorType;
    private String value;
    private String key;
    private List<RuleValidCondition> validConditions;

    public RuleValidCondition() {
    }

    /**
     * 根据业务数据，判断当前生效的条件是否成立
     *
     * @param bizData
     * @return
     */
    public boolean conditionIsTrue(Map<String, Object> bizData) {
        boolean result = false;
        Object valueToCompare = null;
        if (!RuleUtil.validExpression(this.getExpression())) {
            valueToCompare = this.getExpression();
        } else {
            String bizDataKey = RuleUtil.analyzeExpressionBizDataKey(expression);
            if (!bizData.containsKey(bizDataKey)) {
                return result;
            }
            valueToCompare = bizData.get(bizDataKey);
        }

        RuleConditionOperatorTypeEnum operatorTypeEnum = RuleConditionOperatorTypeEnum.getEnumByType(this.getConditionOperatorType());
        switch (operatorTypeEnum) {
            case EQUALS:
                result = Objects.equals(String.valueOf(valueToCompare), this.getValue());
                break;
            case NOT_EQUALS:
                result = !Objects.equals(String.valueOf(valueToCompare), this.getValue());
                break;
            case NUM_LESS_THAN:
                Double oneValue = null != valueToCompare ? Double.parseDouble(String.valueOf(valueToCompare)) : 0.0;
                Double twoValue = Double.parseDouble(this.getValue());
                result = compareTwoNum(oneValue, twoValue);
                break;
            case EXIST_ONE_VALUE:
                Object existOneValueToCompare = null;
                List<RuleValidCondition> validConditions = this.getValidConditions();
                for (RuleValidCondition ruleValidCondition : validConditions) {
                    existOneValueToCompare = bizData.get(RuleUtil.analyzeExpressionBizDataKey(ruleValidCondition.getExpression()));
                    if (Objects.equals(ruleValidCondition.getConditionOperatorType(), RuleConditionOperatorTypeEnum.EQUALS.getType())) {
                        result = result || Objects.equals(String.valueOf(existOneValueToCompare), ruleValidCondition.getValue());
                    }
                    if (Objects.equals(ruleValidCondition.getConditionOperatorType(), RuleConditionOperatorTypeEnum.NOT_EQUALS.getType())) {
                        result = result || !Objects.equals(String.valueOf(existOneValueToCompare), ruleValidCondition.getValue());
                    }
                    if (Objects.equals(ruleValidCondition.getConditionOperatorType(), RuleConditionOperatorTypeEnum.NUM_LESS_THAN.getType())) {
                        Double oneValueForExist = null != existOneValueToCompare ? Double.parseDouble(String.valueOf(existOneValueToCompare)) : 0.0;
                        Double twoValueForExist = Double.parseDouble(ruleValidCondition.getValue());
                        result = result || compareTwoNum(oneValueForExist, twoValueForExist);
                    }

                }
                break;
            default:
                // 没有匹配的枚举类时，表示配置不正确，直接返回false
                result = false;
                break;
        }
        return result;
    }

    //比较两个数值型
    public boolean compareTwoNum(Double oneValue, Double twoValue) {
        if (oneValue < twoValue) {
            return true;
        } else {
            return false;
        }
    }
}
