package com.digiwin.mobile.mobileuibot.core.rule;

/**
 * 功能描述：规则中使用的校验级别枚举类
 *
 * @Author: yanfeng
 * @Date: 2023/10/39 10:20
 */
public enum ValidateRuleLevelEnum {

    /**
     * 错误等级校验
     * 支持绑定组件范围：仅支持单行文本和数字
     */
    ERROR_LEVEL_VERIFICATION(1),

    /**
     * 警示等级校验
     * 支持绑定的组件范围：文本、多行文本、开窗、弹窗、日期、时间、数字
     */
    WARNING_LEVEL_VERIFICATION(2);

    private final Integer levelType;

    ValidateRuleLevelEnum(Integer dataType) {
        this.levelType = dataType;
    }

    public Integer getLevelType() {
        return levelType;
    }
}
