package com.digiwin.mobile.mobileuibot.core.rule.relation;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author wuyang
 * 规则相加操作（目前仅限于日期和数字组件）
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class AddOperator implements Serializable {
    private static final long serialVersionUID = -8415550946248631122L;

    /**
     * 时间的schema
     */
    private String startSchema;
    /**
     * 时长的schema
     */
    private String durationSchema;
    /**
     * 结束时间schema
     */
    private String finishSchema;
    /**
     * 时长单位 1.代表天；2.代表小时；3.代表分钟
     */
    private Integer durationType = 1;
    /**
     * 目标值schema
     */
    private String targetSchema;
}
