package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum;
import com.digiwin.mobile.mobileuibot.core.rule.validate.ValidateRule;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 通用联动规则
 *
 * @author zhangjj
 * @date 2022/3/21 4:48 PM
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CommonRule implements Serializable {
    private static final long serialVersionUID = -862047873665134237L;

    /**
     * 1：当前组件value值变化（非空）;2：当前组件value变为空值；3：选中当前option时触发（此时为弹窗选择组件数据接口选项里）;
     * 4：符合检验规则后，开始联动;
     */
    private Integer condition;
    /**
     * 目标字段schema
     */
    private String targetSchema;
    /**
     * 目标组件是否可用
     */
    private Boolean targetEnable;
    /**
     * 目标组件是否隐藏
     */
    private Boolean targetHidden = false;
    /**
     * 目标组件是否必填
     */
    private Boolean targetRequired;
    /**
     * 目标组件请求数据的URL
     */
    private String targetRequestUrl;
    /**
     * 目标组件选中项的ID(只有单选组件有效，null值表示不做该操作，空字符串表示单选选择置空)
     */
    private String targetSelectId;
    /**
     * 目标组件value值
     */
    private String targetText;
    private String elseTargetText;
    /**
     * 目标组件的提示
     */
    private String targetPlaceholder;

    /**
     * 只用于控制开窗单选是否可以编辑
     */
    private Boolean targetWidowSingleEdit;

    // 联动显示开窗多选组件的部分选项 每个选项字段为{id、text、value，detail}
    private List<Map<String, Object>> targetSelectList;

    /**
     * 时间组件的联动
     */
    private List<TargetDatetime> targetDatetime;
    /**
     * 检验联动
     */
    private List<ValidateRule> validateRuleList;
    /**
     * 目标的data与targetText二选一
     */
    private InputDateTime targetData;
    /**
     * 开关类型，0：代表关闭，1：代表打开
     */
    private String switchType;

    /**
     * 表达式条件值
     */
    private Map<String, Object> expression;
    /**
     * 操作表达式
     */
    private OperatorData operatorData;
    private AddOperator addOperator;

    public static CommonRule create(CommonRule commonRule, Object value) {
        OperatorData operatorData = commonRule.getOperatorData();
        if (operatorData == null) {
            return commonRule;
        }
        if (RuleDataTypeEnum.DOUBLE.getDataType().equalsIgnoreCase(operatorData.getParameterDataType())) {
            if (!StringUtils.hasLength(operatorData.getOperatorValue())) {
                operatorData.setOperatorValue(String.valueOf(value == null ? "" : value));
            }
        }
        return commonRule;
    }
}
