package com.digiwin.mobile.mobileuibot.core.rule.relation;

/**
 * 通用联动规则触发条件
 *
 * @author zhangjj
 * @date 2022/3/21 6:13 PM
 */
public enum CommonRuleCondition {
    /**
     * 当前组件value值变为非空值
     */
    CONDITION_CHANGE_NOT_EMPTY(1),
    /**
     * 当前组件value值变为空值
     */
    CONDITION_CHANGE_EMPTY(2),
    /**
     * 选中当前option时触发（此时为弹窗选择组件数据接口选项里）
     */
    CONDITION_OPTION_SELECT(3),
    /**
     * 符合校验规则后，开始联动
     */
    CONDITION_VALIDATE_LINKAGE(4),
    /**
     * 只有当前值为空的时，才赋予目标值
     */
    CONDITION_EMPTY_RESET(5),

    /**
     * 联动目标栏位赋值
     */
    CONDITION_EQUAL(6),
    ;

    private Integer type;

    public Integer getType() {
        return type;
    }

    CommonRuleCondition(Integer type) {
        this.type = type;
    }
}
