package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.RuleConditionOperatorTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wuyang
 * @date 20230308
 */
@Data
public class OperatorData implements Serializable {

    private static final long serialVersionUID = -9149141548209081497L;
    /**
     * 操作比较的值
     */
    private String operatorValue;
    /**
     * 操作比较运算符号 默认类型是1。1-等于，2-不等于，3-小于，4-小于等于，5-大于，6-大于等于
     */
    private Integer operatorType = RuleConditionOperatorTypeEnum.EQUALS.getType();
    /**
     * 校验参数的数据类型。
     * 指定处理parameter时使用的数据类型。若该字段没有或为空时，前端需要把parameter默认视为string来操作。
     *
     * @see com.digiwin.mobile.mobileuibot.core.rule.RuleDataTypeEnum
     */
    private String parameterDataType;

    /**
     * 操作比较的schema
     */
    private String operatorSchema;
}
