package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：渲染时使用的联动规则</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RelationRule
 * @Author: Zaregoto
 * @Date: 2021/6/24 18:09
 */
@Data
public class RelationRule implements Serializable {
    private static final long serialVersionUID = 976539621081752432L;

    private List<RelationRuleDate> dateRuleList;
    private List<RelationRuleText> textRuleList;
    /**
     * 通用联动规则
     */
    private List<CommonRule> ruleList;

    public RelationRule() {
        this.dateRuleList = new ArrayList<>();
        this.textRuleList = new ArrayList<>();
        this.ruleList = new ArrayList<>();
    }

    public static RelationRule create(Rule rule, Map<String, Object> bizData) {
        Assert.notNull(rule, "rule must not null!");
        Assert.isTrue(rule.getCategory().equalsIgnoreCase(
                RuleCategoryEnum.RELATION.getCategory()), "rule must be relation category!");

        RelationRule relationRule = new RelationRule();
        if (rule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.DATE.getSubcategory())) {
            relationRule.addRelationRuleDate(RelationRuleDate.create(bizData, rule));
        } else if (rule.getSubcategory().equalsIgnoreCase(RuleSubcategoryEnum.TEXT.getSubcategory())) {
            relationRule.addRelationRuleText(RelationRuleText.create(bizData, rule));
        } else {

        }

        return relationRule;
    }

    public static RelationRule createApcWorkShopOnlinePlanStartDate(String dateSchema, String durationSchema, Integer durationType, String targetSchema) {
        RelationRule relationRule = new RelationRule();
        List<CommonRule> ruleList = new ArrayList<>(1);
        CommonRule rule = new CommonRule();
        rule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        rule.setAddOperator(new AddOperator(dateSchema, durationSchema, targetSchema,
                durationType, targetSchema));
        rule.setTargetSchema(targetSchema);
        ruleList.add(rule);
        relationRule.setRuleList(ruleList);
        return relationRule;
    }

    public static void buildTbdsRule(List<CommonRule> commonRules) {
        //1.开始时间和结束时间计算规则
        CommonRule commonRule = new CommonRule();
        commonRule.setCondition(CommonRuleCondition.CONDITION_CHANGE_NOT_EMPTY.getType());
        commonRule.setAddOperator(new AddOperator()
                .setStartSchema("actual_start_time")
                .setDurationSchema("actual_work_hours")
                .setFinishSchema("actual_end_time")
                .setDurationType(2)
                .setTargetSchema("actual_work_hours"));
        commonRule.setTargetSchema("actual_work_hours");
        commonRule.setTargetHidden(null);
        commonRule.setTargetEnable(true);
        commonRules.add(commonRule);
    }

    public void addRelationRuleDate(RelationRuleDate relationRuleDate) {
        if (relationRuleDate != null) {
            this.dateRuleList.add(relationRuleDate);
        }
    }

    public void addRelationRuleText(RelationRuleText relationRuleText) {
        if (relationRuleText != null) {
            this.textRuleList.add(relationRuleText);
        }
    }

    public void addCommonRule(CommonRule commonRule) {
        if (commonRule != null) {
            this.ruleList.add(commonRule);
        }
    }
}
