package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：关联规则-日期型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RelationRuleDate
 * @Author: Zaregoto
 * @Date: 2021/6/24 18:10
 */
public class RelationRuleDate implements Serializable {
    private static final long serialVersionUID = -8270764312853185886L;

    private String targetSchema;
    private String type;

    public RelationRuleDate() {
    }

    public static RelationRuleDate create(Map<String, Object> bizData, Rule rule) {
        Assert.notNull(rule, "rule must not null!");
        Assert.isTrue(rule.getCategory().equalsIgnoreCase(
            RuleCategoryEnum.RELATION.getCategory()), "rule must be relation category!");
        Assert.isTrue(rule.getSubcategory().equalsIgnoreCase(
            RuleSubcategoryEnum.DATE.getSubcategory()), "rule must be date subcategory!");

        RelationRuleDate relationRuleDate = new RelationRuleDate();
        relationRuleDate.setTargetSchema(rule.getTargetSchema());
        relationRuleDate.setType(rule.getType());

        return relationRuleDate;
    }

    public String getTargetSchema() {
        return targetSchema;
    }

    public void setTargetSchema(String targetSchema) {
        this.targetSchema = targetSchema;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
