package com.digiwin.mobile.mobileuibot.core.rule.relation;

import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleCategoryEnum;
import com.digiwin.mobile.mobileuibot.core.rule.RuleSubcategoryEnum;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：关联规则-文本值精确匹配</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: RelationRuleText
 * @Author: Zaregoto
 * @Date: 2021/6/24 18:10
 */
@Data
public class RelationRuleText implements Serializable {
    private static final long serialVersionUID = -3458509415602604913L;

    private String condition;
    private Integer conditionOperatorType;
    private Boolean targetEnable;
    private Boolean targetRequired;
    private String targetSchema;
    private Boolean targetHidden;
    private String targetText;
    private String targetPlaceholder;

    public RelationRuleText() {
    }

    public static RelationRuleText create(Map<String, Object> bizData, Rule rule) {
        Assert.notNull(rule, "rule must not null!");
        Assert.isTrue(rule.getCategory().equalsIgnoreCase(
                RuleCategoryEnum.RELATION.getCategory()), "rule must be relation category!");
        Assert.isTrue(rule.getSubcategory().equalsIgnoreCase(
                RuleSubcategoryEnum.TEXT.getSubcategory()), "rule must be text subcategory!");

        RelationRuleText relationRuleText = new RelationRuleText();
        relationRuleText.setCondition(rule.getCondition());
        relationRuleText.setConditionOperatorType(rule.getConditionOperatorType());
        relationRuleText.setTargetEnable(rule.calculateTargetPropertyResult(bizData, rule.getTargetEnable()));
        relationRuleText.setTargetRequired(rule.calculateTargetPropertyResult(bizData, rule.getTargetRequired()));
        relationRuleText.setTargetHidden(rule.calculateTargetPropertyResult(bizData, rule.getTargetHidden()));
        relationRuleText.setTargetSchema(rule.getTargetSchema());
        relationRuleText.setTargetText(rule.getTargetText());
        relationRuleText.setTargetPlaceholder(rule.getTargetPlaceholder());

        return relationRuleText;
    }
}
