package com.digiwin.mobile.mobileuibot.core.rule.validate;

import java.util.Objects;

/**
 * <p>功能描述：校验类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ValidateRuleTypeEnum
 * @Author: Zaregoto
 * @Date: 2021/6/16 14:55
 */
public enum ValidateRuleTypeEnum {
    /**
     * 正则校验类型
     */
    PATTERN("pattern"),

    /**
     * 必填校验类型
     */
    REQUIRED("required"),

    /**
     * 时间间隔校验类型
     */
    TIMESPACE("timeSpace"),
    /**
     * 指定值
     */
    APPOINT("appoint"),
    /**
     * 日期
     */
    DATE("date");

    private String type;

    ValidateRuleTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static ValidateRuleTypeEnum getEnumByValue(String value) {
        for (ValidateRuleTypeEnum testedEnum : ValidateRuleTypeEnum.values()) {
            if (Objects.equals(testedEnum.getType(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
