package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.list.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：首页工作区项目进展tab组件构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildIndexWorkspaceCardListStrategy
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:39
 */
@Component("uiBotCompDataBuildIndexWorkspaceCardListStrategy")
public class UiBotCompDataBuildIndexWorkspaceCardListStrategy implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {

    private static final Logger logger = LoggerFactory.getLogger(UiBotCompDataBuildIndexWorkspaceCardListStrategy.class);

    @Autowired
    private ProjectService projectService;


    @Override
    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_CARD_LIST.getReuqestId();
    }

    @Override
    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceCardList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTab;
        if (!useMockData && !modelTypeShow) {
            customTab = this.doActually(apiRequest, stopWatch);
        } else {
            customTab = this.doMockData(apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return customTab;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        CustomTabContentContainer<List<Card>> content = new CustomTabContentContainer<>();
        content.setContentCmptType("CARD_LIST");

        List<CardCategory> cardCategoryList = this.projectService.getProjectList(apiRequest);
        List<Card> allCardList = cardCategoryList.stream().map(CardCategory::getCardList).flatMap(Collection::stream).collect(Collectors.toList());
        int actualProjectCount = allCardList.size();
        CustomTabControllerItemEmptyModeEnum emptyModeEnum = null;

        //体系云特定租户的项目卡按创建时间降序排序
        if (projectService.validIsMatchTenantId(apiRequest.getTenantId())) {
            content.setData(actualProjectCount <= 1 ? allCardList :
                    projectService.sortCardListByCreateTime(allCardList).subList(0, 2));
        } else {
            Optional<CardCategory> optAbnormalCardCategory = cardCategoryList.stream().filter(
                            cardCategory -> cardCategory.getCategoryName()
                                    .equals(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "逾期/异常")))
                    .findFirst();
            if (!optAbnormalCardCategory.isPresent()) {
                content.setData(Collections.emptyList());
                emptyModeEnum = actualProjectCount > 0 ? CustomTabControllerItemEmptyModeEnum.EXIST_DATA_BUT_EMPTY_IN_UI_WITH_SHOW_MORE
                        : CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE;
            } else {
                CardCategory abnormalCardCategory = optAbnormalCardCategory.get();
                List<Card> abnormalCardList = abnormalCardCategory.getCardList();
                int abnormalCardCount = abnormalCardCategory.getCardList().size();
                // 需求：最多展示2条
                content.setData(abnormalCardCount <= 1 ? abnormalCardList : abnormalCardList.subList(0, 2));
            }
        }

        CustomTabControllerItem item = CustomTabControllerItem.createAsyncData(
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "项目追踪") + "(" + actualProjectCount
                        + ")", content, emptyModeEnum);

        return item;
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        CustomTabControllerItem uiBotModel = null;
        data = FileUtil.readText("static/appstore-use/MyWorkSpaceCard.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, CustomTabControllerItem.class);
        }

        return uiBotModel;
    }
}
