package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.CustomButton;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildMyTaskListStrategy;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：首页工作区我的任务tab组件构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildIndexWorkspaceTodoListStrategy
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:29
 */
@Component("uiBotCompDataBuildIndexWorkspaceTodoListStrategy")
public class UiBotCompDataBuildIndexWorkspaceTodoListStrategy implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {

    private static final Logger logger = LoggerFactory.getLogger(UiBotCompDataBuildIndexWorkspaceTodoListStrategy.class);

    @Autowired
    private UiBotModelBuildMyTaskListStrategy uiBotModelBuildMyTaskListStrategy;

    @Override
    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId();
    }

    @Override
    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceTodoList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTabControllerItem;
        if (!useMockData && !modelTypeShow) {
            customTabControllerItem = this.doActually(apiRequest, stopWatch);
        } else {
            customTabControllerItem = this.doMockData(apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return customTabControllerItem;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        List<CustomTabContentContainer> content = new ArrayList<>();
        CustomTabContentContainer<List<TaskSummary>> taskContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<Empty> emptyContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<CustomButton> customButtonContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<BlankArea> blankAreaContent = new CustomTabContentContainer<>();

        int actualTaskSummaryCount = 0;
        boolean isSearched = false;
        TodoList todoList =
                this.uiBotModelBuildMyTaskListStrategy.doActually(apiRequest);
        List<TaskSummary> taskSummaryList = todoList.getTodoList();
        actualTaskSummaryCount = taskSummaryList.size();

        if (0 == actualTaskSummaryCount) {
            emptyContent.setContentCmptType("EMPTY");
            emptyContent.setData(Empty.create(
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "暂时没有任务"),
                    true,
                    400,
                    180,
                    "home_tab_no_work_item_prompt"));
            //todo 先后台生成，等下午改成配置文件配置
            blankAreaContent.setContentCmptType("BLANK_AREA");
            blankAreaContent.setData(BlankArea.create(
                    32,
                    1.0
            ));

            customButtonContent.setContentCmptType("CUSTOM_BUTTON");
            Action createTaskAction = new Action<>();
            createTaskAction.setJumpPageId("MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE");
            createTaskAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "新建任务"));
            createTaskAction.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/uibot/model");
            createTaskAction.setScreenShotSwitch(false);
            createTaskAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
            customButtonContent.setData(CustomButton.create(
                    "#6667AB",
                    "#FFFFFF",
                    "+ " + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "新建任务"),
                    "#FFFFFF",
                    28,
                    240,
                    64,
                    createTaskAction
            ));
            content.add(emptyContent);
            content.add(blankAreaContent);
            content.add(customButtonContent);
            content.add(blankAreaContent);
        } else {
            taskSummaryList.forEach(taskSummary -> {
                if (taskSummary.getAction() != null) {
                    taskSummary.getAction().setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                }
            });
            taskContent.setContentCmptType(TodoList.COMPONENT_TYPE);
            taskContent.setData(taskSummaryList);
            taskContent.setFilterList(todoList.getFilterList());
            taskContent.setFilterIdList(todoList.getFilterIdList());
            taskContent.setGroupFilterList(todoList.getGroupFilterList());
            taskContent.setGroupFilterIdList(todoList.getGroupFilterIdList());
            taskContent.setCommonFilter(todoList.getCommonFilter());
            taskContent.setSeniorFilter(todoList.getSeniorFilter());
            taskContent.setIsUseSeniorFilter(todoList.getIsUseSeniorFilter());
            taskContent.setSortFilter(todoList.getSortFilter());
            taskContent.setShowEocSwitch(todoList.getShowEocSwitch());
            taskContent.setShowHandledCardSwitch(todoList.getShowHandledCardSwitch());
            taskContent.setSearchIdList(todoList.getSearchIdList());
            if (!CollectionUtils.isEmpty(todoList.getFilterIdList()) || !CollectionUtils.isEmpty(todoList.getSearchIdList())) {
                isSearched = true;
            }
            taskContent.setSearchUrl(todoList.getSearchUrl());
            taskContent.setQueryParam(todoList.getQueryParam());
            content.add(taskContent);
        }


        CustomTabControllerItem item = CustomTabControllerItem.createAsyncData(
                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "我的任务") + "("
                        + actualTaskSummaryCount + ")", content,
                CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE, isSearched);

        return item;
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        CustomTabControllerItem uiBotModel = null;
        data = FileUtil.readText("static/appstore-use/MyWorkSpaceCardTodoList.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, CustomTabControllerItem.class);
        }

        return uiBotModel;
    }
}
