package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.CustomButton;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItem;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerItemEmptyModeEnum;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoList;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.TodoListResp;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/**
 * <p>功能描述：首页工作区三方待办tab组件构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy
 * @Author: yanfenga
 * @Date: 2024/16/06 16:00
 */
@Slf4j
@Component("uiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy")
public class UiBotCompDataBuildIndexWorkspaceTripartiteTodoListStrategy implements UiBotCompDataBuildStrategy<CustomTabControllerItem> {

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Override
    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId();
    }

    @Override
    public CustomTabControllerItem buildComponentData(ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildIndexWorkspaceTripartiteTodoList");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabControllerItem customTabControllerItem;
        if (!useMockData && !modelTypeShow) {
            customTabControllerItem = this.doActually(apiRequest, stopWatch);
        } else {
            customTabControllerItem = this.doMockData(apiRequest);
        }
        log.debug(stopWatch.prettyPrint());

        return customTabControllerItem;
    }

    private CustomTabControllerItem doActually(ApiRequest apiRequest, StopWatch stopWatch) {
        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
        List<CustomTabContentContainer> content = new ArrayList<>();
        CustomTabContentContainer<List<TaskSummary>> taskContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<Empty> emptyContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<CustomButton> customButtonContent = new CustomTabContentContainer<>();
        CustomTabContentContainer<BlankArea> blankAreaContent = new CustomTabContentContainer<>();

        boolean isSearched = false;
        List<TaskSummary> taskSummaryList = this.getTodoList(apiRequest, localeService);
        if (taskSummaryList.isEmpty()) {
            emptyContent.setContentCmptType("EMPTY");
            emptyContent.setData(Empty.create(
                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "暂时没有待办"),
                    true,
                    400,
                    180,
                    "home_tab_no_work_item_prompt"));
            blankAreaContent.setContentCmptType("BLANK_AREA");
            blankAreaContent.setData(BlankArea.create(
                    32,
                    1.0
            ));
            content.add(emptyContent);
            content.add(blankAreaContent);
            content.add(customButtonContent);
            content.add(blankAreaContent);
        } else {
            taskContent.setContentCmptType(TripartiteTodoList.COMPONENT_TYPE);
            taskContent.setData(taskSummaryList);
            content.add(taskContent);
        }

        return CustomTabControllerItem.createAsyncData(
                localeService.getLanguageValue(apiRequest.getLocale(), "三方待办"), content,
                CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE, isSearched);
    }

    private CustomTabControllerItem doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        CustomTabControllerItem uiBotModel = null;
        data = FileUtil.readText("static/appstore-use/MyWorkSpaceCardTodoList.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, CustomTabControllerItem.class);
        }

        return uiBotModel;
    }

    /**
     * 获取三方待办列表数据
     *
     * @param apiRequest
     * @return
     */
    public List<TaskSummary> getTodoList(ApiRequest apiRequest, LocaleService localeService) {
        ApiRawData rawData = apiRequest.getRawData();
        List<TaskSummary> taskSummaries = new ArrayList<>();
        try {
            //异步请求
            CompletableFuture<TodoListResp> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.selectTodoList(apiRequest.getClientId(),
                    apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()
                    , String.valueOf(rawData.get("appCode")), String.valueOf(rawData.get("appName")), String.valueOf(rawData.get("id"))), this.threadPoolTaskExecutor);
            //获取结果
            TodoListResp todoListResp = supplyAsync.get();
            if (ObjectUtils.isEmpty(todoListResp)) {
                return taskSummaries;
            }
            List<TodoList> todoList = todoListResp.getTodoList();
            if (CollectionUtils.isEmpty(todoList)) {
                return taskSummaries;
            }
            todoList.forEach(todoData -> {
                        if (ObjectUtils.isNotEmpty(todoData)) {
                            taskSummaries.add(TaskSummary.createTripartiteTodo(apiRequest.getLocale(), todoData, localeService));
                        }
                    }
            );
            return taskSummaries;
        } catch (InterruptedException e) {
            log.error("getTodoList interruptedException, error:", e);
            throw new ServiceException(e.getMessage());
        } catch (ExecutionException e) {
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
    }
}