package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：UiBot组件模型构建策略接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildStrategy
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:14
 */
public interface UiBotCompDataBuildStrategy<T extends MobileComponent> {

    String getTypeByRequestId();

    T buildComponentData(ApiRequest apiRequest) throws IOException;

    default List<T> buildComponentDataList(ApiRequest apiRequest) throws IOException {
        return new ArrayList<>();
    }
}
